/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.logger;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.collab.common.internal.logger.IntentLoggerDescriptor;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentLoggerRegistry {
    private static final Map<IntentLoggerDescriptor, IIntentLogger> declaredLoggers = Maps.newLinkedHashMap();

    private IntentLoggerRegistry() {
    }

    public static Collection<IIntentLogger> getDeclaredLoggers() {
        for (Map.Entry<IntentLoggerDescriptor, IIntentLogger> descriptorToLogger : declaredLoggers.entrySet()) {
            if (descriptorToLogger.getValue() != null) continue;
            descriptorToLogger.setValue(descriptorToLogger.getKey().createLogger());
        }
        return declaredLoggers.values();
    }

    public static void addLogger(IntentLoggerDescriptor intentLoggerDescriptor) {
        declaredLoggers.put(intentLoggerDescriptor, null);
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentLoggerDescriptor extension : declaredLoggers.keySet()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            declaredLoggers.remove(extension);
        }
    }

    public static void clearContributedLoggers() {
        declaredLoggers.clear();
    }
}

