/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Font;

public class PageBreaksFigure
extends Figure {
    public static final boolean FIGURE = true;
    public static final boolean FEEDBACK = false;
    private int rows = 1;
    private int cols = 1;
    private List recList;
    private boolean figureType = true;

    public PageBreaksFigure(boolean type) {
        this.figureType = type;
        if (type) {
            this.recList = new ArrayList(5);
        }
    }

    private int getBorderLineWidth() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(7);
    }

    private int getLineWidth() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(1);
    }

    private int getBottomPageMargin() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(60);
    }

    public void setPageCount(int rows, int cols) {
        this.rows = Math.max(1, rows);
        this.cols = Math.max(1, cols);
    }

    public void setRows(int rows) {
        this.rows = Math.max(1, rows);
    }

    public void setCols(int cols) {
        this.cols = Math.max(1, cols);
    }

    public Point getPageCount() {
        return new Point(this.rows, this.cols);
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    protected void paintFigure(Graphics g) {
        if (this.figureType) {
            this.paintPageFigure(g);
        } else {
            this.paintFeedbackFigure(g);
        }
    }

    private void paintPageFigure(Graphics g) {
        super.paintFigure(g);
        this.recList.clear();
        Rectangle r = this.getBounds();
        g.setForegroundColor(ColorConstants.blue);
        g.setBackgroundColor(ColorConstants.blue);
        int borderLineWidth = this.getBorderLineWidth();
        Rectangle top = new Rectangle(r.x, r.y, r.width, borderLineWidth);
        this.recList.add(top);
        Rectangle right = new Rectangle(r.x + r.width - borderLineWidth, r.y, borderLineWidth + 1, r.height);
        this.recList.add(right);
        Rectangle left = new Rectangle(r.x, r.y, borderLineWidth, r.height);
        this.recList.add(left);
        Rectangle bottom = new Rectangle(r.x, r.y + r.height - borderLineWidth, r.width, borderLineWidth + 1);
        this.recList.add(bottom);
        int i = 0;
        while (i < this.recList.size()) {
            g.fillRectangle((Rectangle)this.recList.get(i));
            ++i;
        }
        g.setLineWidth(this.getLineWidth());
        Point location = this.getLocation();
        int colSize = (int)Math.floor(r.width / this.cols);
        int i2 = 1;
        while (i2 < this.cols) {
            int colsOffset = colSize * i2;
            Rectangle rec = new Rectangle(location.x + colsOffset, location.y, this.getLineWidth(), r.height);
            this.recList.add(rec);
            g.fillRectangle(rec);
            ++i2;
        }
        int rowSize = (int)Math.floor(r.height / this.rows);
        int i3 = 1;
        while (i3 < this.rows) {
            int rowOffset = rowSize * i3;
            Rectangle rec = new Rectangle(location.x, location.y + rowOffset, r.width, this.getLineWidth());
            this.recList.add(rec);
            g.fillRectangle(rec);
            ++i3;
        }
        int halfPageSize = (int)Math.floor(colSize / 2);
        int col = 1;
        while (col < this.cols + 1) {
            int row = 1;
            while (row < this.rows + 1) {
                int colsOffset = location.x + colSize * col;
                int rowOffset = location.y + rowSize * row;
                int topCenter = colsOffset - halfPageSize;
                String pageNumber = String.valueOf(row) + " - " + col;
                Dimension size = FigureUtilities.getTextExtents((String)pageNumber, (Font)this.getFont());
                g.drawString(pageNumber, topCenter - size.width, rowOffset - (this.getBottomPageMargin() + size.height));
                ++row;
            }
            ++col;
        }
    }

    private void paintFeedbackFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = this.getBounds();
        g.setForegroundColor(ColorConstants.blue);
        g.setBackgroundColor(ColorConstants.blue);
        g.setLineStyle(4);
        g.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        int colSize = (int)Math.floor(r.width / this.cols);
        int i = 1;
        while (i < this.cols) {
            int colsOffset = colSize * i;
            g.drawLine(r.x + colsOffset, r.y, r.x + colsOffset, r.y + r.height);
            ++i;
        }
        int rowSize = (int)Math.floor(r.height / this.rows);
        int i2 = 1;
        while (i2 < this.rows) {
            int rowOffset = rowSize * i2;
            g.drawLine(r.x, r.y + rowOffset, r.x + r.width, r.y + rowOffset);
            ++i2;
        }
    }

    public boolean containsPoint(int x, int y) {
        if (!this.figureType) {
            return false;
        }
        if (this.isOpaque()) {
            return super.containsPoint(x, y);
        }
        int i = 0;
        while (i < this.recList.size()) {
            Rectangle r = (Rectangle)this.recList.get(i);
            if (r.contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

