/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.builder.GModelElementBuilder;
import org.eclipse.glsp.graph.util.GraphUtil;

public abstract class AbstractGEdgeBuilder<T extends GEdge, E extends AbstractGEdgeBuilder<T, E>>
extends GModelElementBuilder<T, E> {
    protected GModelElement source;
    protected String sourceId;
    protected GModelElement target;
    protected String targetId;
    protected List<GPoint> routingPoints = new ArrayList<GPoint>();
    protected String routerKind;

    public AbstractGEdgeBuilder(String type) {
        super(type);
    }

    public E source(GModelElement source) {
        this.source = source;
        this.sourceId = source.getId();
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E sourceId(String sourceId) {
        this.sourceId = sourceId;
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E target(GModelElement target) {
        this.target = target;
        this.targetId = target.getId();
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E targetId(String targetId) {
        this.targetId = targetId;
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E addRoutingPoint(GPoint point) {
        this.routingPoints.add(point);
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E addRoutingPoint(double x, double y) {
        return this.addRoutingPoint(GraphUtil.point(x, y));
    }

    public E addRoutingPoints(List<GPoint> routingPoints) {
        this.routingPoints.addAll(routingPoints);
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    public E routerKind(String routerKind) {
        this.routerKind = routerKind;
        return (E)((AbstractGEdgeBuilder)this.self());
    }

    @Override
    protected void setProperties(T edge) {
        super.setProperties(edge);
        edge.setSourceId(this.sourceId);
        edge.setTargetId(this.targetId);
        edge.setRouterKind(this.routerKind);
        if (this.source != null) {
            edge.setSource(this.source);
        }
        if (this.target != null) {
            edge.setTarget(this.target);
        }
        edge.getRoutingPoints().addAll(this.routingPoints);
    }
}

