/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.Pos;
import org.eclipse.etrice.ui.structure.support.PosAndSize;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class DefaultPositionProvider
implements IPositionProvider {
    private Map<String, Position> obj2pos = new HashMap<String, Position>();
    private Map<String, Position> obj2text = new HashMap<String, Position>();
    private Set<RoomClass> mappedClasses = new HashSet<RoomClass>();
    private Parent parent = new Parent();

    private DefaultPositionProvider() {
        this.parent.bo = null;
        this.parent.inner = new PosAndSize(40, 40, 800, 500);
    }

    public DefaultPositionProvider(ActorContainerRef acr) {
        this();
        this.parent.bo = acr;
        this.parent.inner = new PosAndSize(30, 30, 180, 80);
        this.mapChildrenInterfaceItems(acr);
    }

    public DefaultPositionProvider(StructureClass sc, ContainerShape scShape, Set<EObject> toLayout) {
        this();
        this.parent.bo = sc;
        this.parent.inner = DiagramUtil.getPosAndSize((GraphicsAlgorithm)scShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0));
        int width = this.parent.inner.getW();
        int height = this.parent.inner.getH();
        int y = 20;
        ArrayList<ActorContainerRef> refs = new ArrayList<ActorContainerRef>();
        ArrayList<InterfaceItem> ifItems = new ArrayList<InterfaceItem>();
        ArrayList<InterfaceItem> intPorts = new ArrayList<InterfaceItem>();
        for (EObject obj : toLayout) {
            if (obj instanceof ActorContainerRef) {
                refs.add((ActorContainerRef)obj);
                continue;
            }
            if (!(obj instanceof InterfaceItem)) continue;
            InterfaceItem item = (InterfaceItem)obj;
            if (item instanceof Port && SupportUtil.getInstance().getRoomHelpers().isInternal((Port)item)) {
                intPorts.add(item);
                continue;
            }
            ifItems.add(item);
        }
        this.layoutInterfaceItems(ifItems, width, height, -40);
        this.layoutInterfaceItems(intPorts, width, height, y);
        this.layoutActorRefs(refs, width, height, y += 100);
    }

    public DefaultPositionProvider(StructureClass sc) {
        this();
        this.parent.bo = sc;
        int width = 800;
        int height = 500;
        int y = 20;
        this.layoutInterfaceItems(SupportUtil.getInstance().getRoomHelpers().getInterfaceItems(sc, true), width, height, -40);
        ArrayList intPorts = new ArrayList();
        if (sc instanceof ActorClass) {
            ActorClass base = (ActorClass)sc;
            while (base != null) {
                intPorts.addAll(base.getInternalPorts());
                base = base.getActorBase();
            }
        }
        this.layoutInterfaceItems(intPorts, width, height, y);
        this.layoutActorRefs(SupportUtil.getInstance().getRoomHelpers().getAllActorContainerRefs(sc), width, height, y += 100);
    }

    @Override
    public IPositionProvider setNewParent(EObject parent, PosAndSize invisibleRect, PosAndSize innerRect) {
        DefaultPositionProvider pp = new DefaultPositionProvider();
        pp.mappedClasses = this.mappedClasses;
        pp.obj2pos = this.obj2pos;
        pp.obj2text = this.obj2text;
        pp.parent.bo = parent;
        pp.parent.inner = innerRect;
        return pp;
    }

    @Override
    public PosAndSize getPosition(EObject bo) {
        Position pos = this.obj2pos.get(this.getKey(bo));
        int width = 0;
        int height = 0;
        if (bo instanceof InterfaceItem && this.parent.bo instanceof ActorContainerRef) {
            height = 60;
            width = 60;
        }
        if (pos != null) {
            return new PosAndSize((int)(pos.x * (double)this.parent.inner.getW()) + this.parent.inner.getX() - width / 2, (int)(pos.y * (double)this.parent.inner.getH()) + this.parent.inner.getY() - height / 2, -1, -1);
        }
        return null;
    }

    @Override
    public boolean contains(EObject obj) {
        String key = this.getKey(obj);
        return this.obj2pos.containsKey(key) || this.obj2text.containsKey(key);
    }

    private void mapChildrenInterfaceItems(ActorContainerRef acr) {
        ActorClass acc = null;
        if (acr instanceof ActorRef) {
            acc = ((ActorRef)acr).getType();
        } else if (acr instanceof SubSystemRef) {
            acc = ((SubSystemRef)acr).getType();
        }
        if (acc == null || this.mappedClasses.contains(acc)) {
            return;
        }
        Diagram diagram = new DiagramAccess().getDiagram((EObject)acc);
        if (diagram == null) {
            return;
        }
        ContainerShape scShape = DiagramUtil.findScShape(diagram);
        if (scShape == null) {
            return;
        }
        ILinkService linkService = Graphiti.getLinkService();
        EObject acc2 = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)scShape);
        if (!acc2.eResource().getURI().equals(acc.eResource().getURI())) {
            return;
        }
        if (scShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().isEmpty()) {
            return;
        }
        GraphicsAlgorithm borderRect = (GraphicsAlgorithm)scShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        for (Shape child : scShape.getChildren()) {
            EObject bo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
            if (!(bo instanceof InterfaceItem)) continue;
            GraphicsAlgorithm ga = child.getGraphicsAlgorithm();
            Position pos = new Position((double)(ga.getX() - borderRect.getX() + ga.getWidth() / 2) / (double)borderRect.getWidth(), (double)(ga.getY() - borderRect.getY() + ga.getHeight() / 2) / (double)borderRect.getHeight());
            this.obj2pos.put(this.getKey(bo), pos);
        }
        this.mappedClasses.add((RoomClass)acc);
    }

    private void layoutActorRefs(List<? extends ActorContainerRef> actorRefs, int width, int height, int y0) {
        int minGap = 15;
        int ncols = width / (180 + minGap);
        int gap = (width - ncols * 180) / (ncols + 1);
        int delta = gap + 180;
        int x0 = -30 + gap;
        int i = 0;
        for (ActorContainerRef actorContainerRef : actorRefs) {
            int row = i / ncols;
            int col = i % ncols;
            int nLastRow = actorRefs.size() % ncols;
            if (row >= actorRefs.size() / ncols && nLastRow > 0) {
                gap = (width - nLastRow * 180) / (nLastRow + 1);
                delta = gap + 180;
                x0 = -30 + gap;
            }
            int x = x0 + delta * col;
            int y = y0 + 110 * row;
            this.obj2pos.put(this.getKey((EObject)actorContainerRef), new Position((double)x / (double)width, (double)y / (double)height));
            ++i;
        }
    }

    private void layoutInterfaceItems(List<? extends InterfaceItem> items, int width, int height, int y0) {
        int n = items.size();
        int delta = width / (n + 1);
        int pos = -40 + delta;
        for (InterfaceItem interfaceItem : items) {
            this.obj2pos.put(this.getKey((EObject)interfaceItem), new Position((double)pos / (double)width, (double)y0 / (double)height));
            pos += delta;
        }
    }

    private String getKey(EObject obj) {
        return DiagramUtil.getResourcePath(obj);
    }

    @Override
    public List<Pos> getConnectionBendpoints(EObject obj) {
        return new ArrayList<Pos>();
    }

    @Override
    public PosAndSize getDiagramPosition() {
        return null;
    }

    @Override
    public Pos getConnectionText(EObject obj) {
        return null;
    }

    private class Parent {
        EObject bo;
        PosAndSize inner;

        private Parent() {
        }
    }

    private class Position {
        double x;
        double y;

        public Position(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

