/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolution;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolutionAcceptor;
import org.eclipse.xtext.ide.editor.quickfix.IQuickFixProvider;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

public abstract class AbstractIdeQuickfixProvider
implements IQuickFixProvider {
    @Inject
    private Provider<DiagnosticResolutionAcceptor> resolutionAcceptorProvider;

    public List<DiagnosticResolution> getResolutions(ICodeActionService2.Options options, Diagnostic diagnostic) {
        if (diagnostic.getCode() == null || diagnostic.getCode().getLeft() == null) {
            return List.of();
        }
        Function<QuickfixMethodContext, List<DiagnosticResolution>> method = this.getQuickfixMethod((String)diagnostic.getCode().getLeft());
        if (method == null) {
            return List.of();
        }
        QuickfixMethodContext context = new QuickfixMethodContext(options, diagnostic);
        return method.apply(context);
    }

    public boolean handlesDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getCode() == null || diagnostic.getCode().getLeft() == null) {
            return false;
        }
        return this.getQuickfixMethod((String)diagnostic.getCode().getLeft()) != null;
    }

    protected abstract Function<QuickfixMethodContext, List<DiagnosticResolution>> getQuickfixMethod(String var1);

    protected class QuickfixMethodContext {
        private final ICodeActionService2.Options options;
        private final Diagnostic diagnostic;

        public QuickfixMethodContext(ICodeActionService2.Options options, Diagnostic diagnostic) {
            this.options = options;
            this.diagnostic = diagnostic;
        }

        public Diagnostic diagnostic() {
            return this.diagnostic;
        }

        public Document document() {
            return this.options.getDocument();
        }

        public Resource resource() {
            return this.options.getResource();
        }

        public List<String> issueData() {
            return ((JsonArray)this.diagnostic.getData()).asList().stream().map(JsonElement::getAsString).toList();
        }

        public DiagnosticResolution createResolution(String label, IChangeSerializer.IModification<EObject> modification) {
            DiagnosticResolutionAcceptor acceptor = (DiagnosticResolutionAcceptor)AbstractIdeQuickfixProvider.this.resolutionAcceptorProvider.get();
            acceptor.accept(label, modification);
            return (DiagnosticResolution)acceptor.getDiagnosticResolutions(this.options, this.diagnostic).get(0);
        }

        public DiagnosticResolution createResolution(String label, List<TextEdit> textEdits) {
            DiagnosticResolutionAcceptor acceptor = (DiagnosticResolutionAcceptor)AbstractIdeQuickfixProvider.this.resolutionAcceptorProvider.get();
            acceptor.accept(label, (diagnostic, eobject, document) -> textEdits);
            return (DiagnosticResolution)acceptor.getDiagnosticResolutions(this.options, this.diagnostic).get(0);
        }

        public List<DiagnosticResolution> createSingleResolution(String label, IChangeSerializer.IModification<EObject> modification) {
            return List.of(this.createResolution(label, modification));
        }

        public List<DiagnosticResolution> createSingleResolution(String label, List<TextEdit> textEdits) {
            return List.of(this.createResolution(label, textEdits));
        }
    }
}

