/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.knowm.xchart.DialSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.internal.chartpart.PlotContent_Pie;
import org.knowm.xchart.style.DialStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Dial<ST extends DialStyler, S extends DialSeries>
extends PlotContent_<ST, S> {
    private final ST styler;
    private final NumberFormat df = DecimalFormat.getPercentInstance();
    private double height_r;

    PlotContent_Dial(Chart<ST, S> chart) {
        super(chart);
        this.styler = (DialStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        Rectangle2D pieBounds = this.getPieBounds();
        boolean axisTickLabelsVisible = ((DialStyler)this.styler).isAxisTickLabelsVisible();
        double arcAngle = ((DialStyler)this.styler).getArcAngle();
        double donutThickness = ((DialStyler)this.styler).getDonutThickness();
        int axisTitlePadding = ((DialStyler)this.styler).getAxisTitlePadding();
        double[] axisTickValues = ((DialStyler)this.styler).getAxisTickValues();
        int markCount = axisTickValues.length;
        String[] axisTickLabels = ((DialStyler)this.styler).getAxisTickLabels();
        double[] fromArr = new double[]{((DialStyler)this.styler).getMiddleFrom(), ((DialStyler)this.styler).getLowerFrom(), ((DialStyler)this.styler).getUpperFrom()};
        double[] toArr = new double[]{((DialStyler)this.styler).getMiddleTo(), ((DialStyler)this.styler).getLowerTo(), ((DialStyler)this.styler).getUpperTo()};
        Color[] donutColorArr = new Color[]{((DialStyler)this.styler).getMiddleColor(), ((DialStyler)this.styler).getLowerColor(), ((DialStyler)this.styler).getUpperColor()};
        double dountStartAngle = arcAngle / 2.0 + 90.0;
        for (int i = 0; i < donutColorArr.length; ++i) {
            double to = toArr[i];
            double from = fromArr[i];
            if (to <= from || to < 0.0 || from < 0.0) continue;
            double totalAngle = (to - from) * arcAngle;
            double startAngle = dountStartAngle - from * arcAngle - totalAngle;
            Shape donutSlice = PlotContent_Pie.getDonutSliceShape(pieBounds, donutThickness, startAngle, totalAngle);
            g.setColor(donutColorArr[i]);
            g.fill(donutSlice);
            g.draw(donutSlice);
        }
        double xDiameter = pieBounds.getWidth() / 2.0;
        double yDiameter = pieBounds.getHeight() / 2.0;
        double xCenter = pieBounds.getX() + xDiameter;
        double yCenter = pieBounds.getY() + yDiameter;
        if (markCount > 0 && ((DialStyler)this.styler).isAxisTicksMarksVisible()) {
            g.setColor(((DialStyler)this.styler).getAxisTickMarksColor());
            g.setStroke(((DialStyler)this.styler).getAxisTickMarksStroke());
            for (int i = 0; i < markCount; ++i) {
                double xc;
                double angle = -axisTickValues[i] * arcAngle + arcAngle / 2.0 + 90.0;
                double radians = Math.toRadians(angle);
                double cos = Math.cos(radians);
                double sin = Math.sin(radians);
                double xOffset = xCenter + cos * xDiameter;
                double yOffset = yCenter - sin * yDiameter;
                double xOffset2 = xCenter + cos * xDiameter * (1.0 - donutThickness);
                double yOffset2 = yCenter - sin * yDiameter * (1.0 - donutThickness);
                Line2D.Double line = new Line2D.Double(xOffset2, yOffset2, xOffset, yOffset);
                g.setColor(((DialStyler)this.styler).getAxisTickMarksColor());
                g.setStroke(((DialStyler)this.styler).getAxisTickMarksStroke());
                g.draw(line);
                if (!axisTickLabelsVisible) continue;
                String labels = axisTickLabels[i];
                TextLayout textLayout = new TextLayout(labels, ((DialStyler)this.styler).getAxisTitleFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                Rectangle2D labelBounds = shape.getBounds2D();
                double labelWidth = labelBounds.getWidth();
                double labelHeight = labelBounds.getHeight();
                double yc = 0.0;
                if (axisTickValues[i] < 0.49) {
                    xc = 0.0;
                } else if (axisTickValues[i] > 0.51) {
                    xc = -labelWidth;
                } else {
                    xc = -labelWidth / 2.0;
                    yc = labelHeight / 2.0;
                }
                xOffset2 = xCenter + cos * (xDiameter - (double)axisTitlePadding) * (1.0 - donutThickness);
                yOffset2 = yCenter - sin * (yDiameter - (double)axisTitlePadding) * (1.0 - donutThickness);
                double tx = xOffset2 + xc;
                double ty = yOffset2 + yc + labelHeight / 2.0;
                g.setColor(((Styler)this.styler).getChartFontColor());
                g.setFont(((Styler)this.styler).getBaseFont());
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
        }
        Map map = this.chart.getSeriesMap();
        for (DialSeries series : map.values()) {
            double[][] angleValues;
            if (!series.isEnabled()) continue;
            if (((DialStyler)this.styler).isAxisTitleVisible()) {
                TextLayout textLayout = new TextLayout(series.getName(), ((DialStyler)this.styler).getAxisTitleFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                Rectangle2D labelBounds = shape.getBounds2D();
                double labelWidth = labelBounds.getWidth();
                double labelHeight = labelBounds.getHeight();
                double tx = xCenter - labelWidth / 2.0;
                double ty = yCenter - yDiameter / 2.0 + labelHeight / 2.0;
                g.setColor(((Styler)this.styler).getChartFontColor());
                g.setFont(((DialStyler)this.styler).getAxisTitleFont());
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
            double value = series.getValue();
            if (((DialStyler)this.styler).isLabelsVisible()) {
                String label = series.getLabel();
                if (label == null) {
                    if (((Styler)this.styler).getDecimalPattern() != null) {
                        DecimalFormat df = new DecimalFormat(((Styler)this.styler).getDecimalPattern());
                        label = df.format(value);
                    } else {
                        label = this.df.format(value);
                    }
                }
                if (!label.isEmpty()) {
                    TextLayout textLayout = new TextLayout(label, ((DialStyler)this.styler).getLabelsFont(), new FontRenderContext(null, true, false));
                    Shape shape = textLayout.getOutline(null);
                    Rectangle2D labelBounds = shape.getBounds2D();
                    double labelnWidth = labelBounds.getWidth();
                    double labelHeight = labelBounds.getHeight();
                    double tx = xCenter - labelnWidth / 2.0;
                    double ty = yCenter + labelHeight / 2.0;
                    ty = ((DialStyler)this.styler).getArcAngle() > 180.0 ? (ty += this.height_r * Math.cos(Math.toRadians((360.0 - ((DialStyler)this.styler).getArcAngle()) / 2.0)) / 2.0) : (ty -= yDiameter / 4.0);
                    g.setColor(((Styler)this.styler).getChartFontColor());
                    g.setFont(((DialStyler)this.styler).getAxisTitleFont());
                    AffineTransform orig = g.getTransform();
                    AffineTransform at = new AffineTransform();
                    at.translate(tx, ty);
                    g.transform(at);
                    g.fill(shape);
                    g.setTransform(orig);
                }
            }
            double angle = -value * arcAngle + arcAngle / 2.0 + 90.0;
            double radians = Math.toRadians(angle);
            double arrowLengthPercentage = ((DialStyler)this.styler).getArrowLengthPercentage();
            double arrowArcAngle = ((DialStyler)this.styler).getArrowArcAngle();
            double arrowArcPercentage = ((DialStyler)this.styler).getArrowArcPercentage();
            double xOffset = xCenter + Math.cos(radians) * (xDiameter * arrowLengthPercentage);
            double yOffset = yCenter - Math.sin(radians) * (yDiameter * arrowLengthPercentage);
            Path2D.Double path = new Path2D.Double();
            if (((Styler)this.styler).isToolTipsEnabled()) {
                String label = series.getLabel();
                if (label == null) {
                    if (((Styler)this.styler).getDecimalPattern() != null) {
                        DecimalFormat df = new DecimalFormat(((Styler)this.styler).getDecimalPattern());
                        label = df.format(value);
                    } else {
                        label = this.df.format(value);
                    }
                }
                this.toolTips.addData(path, xOffset, yOffset + 10.0, 0.0, label);
            }
            path.moveTo(xCenter, yCenter);
            for (double[] ds : angleValues = new double[][]{{-arrowArcAngle, arrowArcPercentage}, {0.0, 1.0}, {arrowArcAngle, arrowArcPercentage}}) {
                radians = Math.toRadians(angle - ds[0]);
                double diameterPerct = arrowLengthPercentage * ds[1];
                xOffset = xCenter + Math.cos(radians) * (xDiameter * diameterPerct);
                yOffset = yCenter - Math.sin(radians) * (yDiameter * diameterPerct);
                path.lineTo(xOffset, yOffset);
            }
            path.closePath();
            g.setColor(((DialStyler)this.styler).getArrowColor());
            g.fill(path);
            g.setColor(((DialStyler)this.styler).getArrowColor());
            g.draw(path);
        }
    }

    private Rectangle2D getPieBounds() {
        double pieFillPercentage = ((Styler)this.styler).getPlotContentSize();
        double halfBorderPercentage = (1.0 - pieFillPercentage) / 2.0;
        double boundsWidth = this.getBounds().getWidth();
        double boundsHeight = this.getBounds().getHeight();
        double pieBounds_x = this.getBounds().getX();
        double pieBounds_y = this.getBounds().getY();
        double pieBounds_w = 0.0;
        double pieBounds_h = 0.0;
        double r = boundsHeight * pieFillPercentage / 2.0;
        if (((DialStyler)this.styler).isCircular()) {
            if (((DialStyler)this.styler).getArcAngle() > 180.0) {
                double cos = Math.cos(Math.toRadians((360.0 - ((DialStyler)this.styler).getArcAngle()) / 2.0));
                if (2.0 * (r += r * (1.0 - cos) / (1.0 + cos)) > boundsWidth * pieFillPercentage) {
                    r = boundsWidth * pieFillPercentage / 2.0;
                    pieBounds_x += boundsWidth * halfBorderPercentage;
                    pieBounds_y += (boundsHeight - r - r * cos) / 2.0;
                } else {
                    pieBounds_x += boundsWidth / 2.0 - r;
                    pieBounds_y += boundsHeight * halfBorderPercentage;
                }
            } else {
                r = boundsHeight * pieFillPercentage;
                double sin = Math.sin(Math.toRadians(((DialStyler)this.styler).getArcAngle() / 2.0));
                if (2.0 * sin * r > boundsWidth * pieFillPercentage) {
                    r = boundsWidth * pieFillPercentage / 2.0 / sin;
                    pieBounds_x += boundsWidth * halfBorderPercentage - r * (1.0 - sin);
                    pieBounds_y += (boundsHeight - r) / 2.0;
                } else {
                    pieBounds_x += boundsWidth / 2.0 - r;
                    pieBounds_y += boundsHeight * halfBorderPercentage;
                }
            }
            pieBounds_w = r * 2.0;
            pieBounds_h = r * 2.0;
        } else {
            pieBounds_x += boundsWidth * halfBorderPercentage;
            pieBounds_y += boundsHeight * halfBorderPercentage;
            pieBounds_w = boundsWidth * pieFillPercentage;
            if (((DialStyler)this.styler).getArcAngle() > 180.0) {
                double cos = Math.cos(Math.toRadians((360.0 - ((DialStyler)this.styler).getArcAngle()) / 2.0));
                r += r * (1.0 - cos) / (1.0 + cos);
                pieBounds_h = r * 2.0;
            } else {
                pieBounds_h = boundsHeight * pieFillPercentage * 2.0;
            }
        }
        this.height_r = r;
        return new Rectangle2D.Double(pieBounds_x, pieBounds_y, pieBounds_w, pieBounds_h);
    }
}

