//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.simulator.output.svgviz;

import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.svg.SvgViewer;
import org.eclipse.escet.common.svg.SvgVisualizer;

/** CIF simulator SVG visualizer. */
public class CifSimulatorSvgVisualizer extends SvgVisualizer {
    /** Constructor for the {@link CifSimulatorSvgVisualizer} class. */
    public CifSimulatorSvgVisualizer() {
        super(svgAbsName -> {
            String name = SvgViewer.DEFAULT_NAME_PROVIDER.apply(svgAbsName);
            name = Paths.pathChangeExtension(name, "svg", null);
            return name;
        });
    }
}
