/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.util.List;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxer;
import org.eclipse.escet.common.box.HBox;

public class BoxUtils {
    private BoxUtils() {
    }

    public static <T extends Box> HBox join(List<T> elements, String separator) {
        HBox rslt = new HBox(separator);
        for (Box element : elements) {
            rslt.add(element);
        }
        return rslt;
    }

    public static <T extends Box> HBox join(List<T> elements, String prefix, String separator, String postfix) {
        HBox rslt = new HBox();
        rslt.add(prefix);
        boolean first = true;
        for (Box element : elements) {
            if (!first) {
                rslt.add(separator);
            }
            first = false;
            rslt.add(element);
        }
        rslt.add(postfix);
        return rslt;
    }

    public static <T> HBox boxAndJoin(Boxer<T> boxer, List<T> elements, String separator) {
        HBox rslt = new HBox(separator);
        for (T element : elements) {
            rslt.add(boxer.box(element));
        }
        return rslt;
    }

    public static <T> HBox boxAndJoin(Boxer<T> boxer, List<T> elements, String prefix, String separator, String postfix) {
        HBox rslt = new HBox();
        rslt.add(prefix);
        boolean first = true;
        for (T element : elements) {
            if (!first) {
                rslt.add(separator);
            }
            first = false;
            rslt.add(boxer.box(element));
        }
        rslt.add(postfix);
        return rslt;
    }
}

