/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atompub;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.introspection.IWorkspace;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Source;
import com.google.gdata.model.atom.TextContent;
import com.google.gdata.model.atompub.Collection;
import com.google.gdata.util.Namespaces;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends Element
implements IWorkspace {
    public static final ElementKey<Void, Workspace> KEY = ElementKey.of(new QName(Namespaces.atomPubStandardNs, "workspace"), Workspace.class);
    public static final AttributeKey<String> TITLE = AttributeKey.of(new QName("title"));

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(TITLE).setVisible(false);
        builder.addElement(Collection.KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addElement(Source.TITLE).setRequired(true);
    }

    public Workspace() {
        super(KEY);
    }

    protected Workspace(ElementKey<?, ? extends Workspace> key) {
        super(key);
    }

    protected Workspace(ElementKey<?, ? extends Workspace> key, Element source) {
        super(key, source);
    }

    public Workspace(TextContent title) {
        this();
        this.setTitle(title);
    }

    public List<Collection> getCollections() {
        return super.getElements(Collection.KEY);
    }

    public void addCollection(Collection collection) {
        super.addElement(Collection.KEY, (Element)collection);
    }

    @Override
    public Collection addCollection(String collectionUri, String title, String ... acceptedTypes) {
        Collection collection = new Collection(collectionUri, TextContent.plainText(title), acceptedTypes);
        this.addCollection(collection);
        return collection;
    }

    public boolean removeCollection(Collection collection) {
        return super.removeElement(Collection.KEY, collection);
    }

    public boolean hasCollections() {
        return super.hasElement(Collection.KEY);
    }

    public TextContent getTitle() {
        return super.getElement(Source.TITLE);
    }

    public void setTitle(TextContent title) {
        this.setAttributeValue(TITLE, (Object)(title == null ? null : title.getPlainText()));
        super.setElement(Source.TITLE, (Element)title);
    }

    public boolean hasTitle() {
        return super.hasElement(Source.TITLE);
    }

    @Override
    public Element resolve(ElementMetadata<?, ?> meta, ValidationContext vc) {
        String titleAttribute = this.getAttributeValue(TITLE);
        TextContent title = this.getElement(Source.TITLE);
        if (titleAttribute != null) {
            if (title == null) {
                title = TextContent.plainText(titleAttribute);
                this.addElement(Source.TITLE, (Element)title);
            } else {
                String titleContent = title.getPlainText();
                if (!titleAttribute.equals(titleContent)) {
                    vc.addError((Element)this, CoreErrorDomain.ERR.duplicateTitle);
                }
            }
        } else if (title != null) {
            titleAttribute = title.getPlainText();
            this.setAttributeValue(TITLE, (Object)titleAttribute);
        }
        return super.resolve(meta, vc);
    }

    @Override
    public String toString() {
        return "{Workspace" + super.toString() + "}";
    }
}

