/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.OrgUnitManagementGUI;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesComposite;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserComposite
extends PropertiesComposite {
    private ACUser user;
    private OrgUnitManagementGUI orgUnitMgmtGUI;

    public UserComposite(Composite parent, int style, AdminBroker adminBroker, OrgUnitManagementGUI orgUnitMgmtGUI) {
        super(parent, style, adminBroker);
        this.orgUnitMgmtGUI = orgUnitMgmtGUI;
        this.createControls();
    }

    @Override
    protected void removeOrgUnit(ACOrgUnit group) {
        try {
            this.getAdminBroker().removeGroup(this.user.getId(), ((ACGroup)group).getId());
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addExistingOrgUnit(ACOrgUnit group) {
        try {
            if (group != null) {
                this.getAdminBroker().addMember(((ACGroup)group).getId(), this.user.getId());
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addNewOrgUnit() {
        try {
            List<ACGroup> groups = this.getGroups();
            for (ACGroup newGroup : groups) {
                this.getAdminBroker().addMember(newGroup.getId(), this.user.getId());
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        this.getTableViewer().refresh();
    }

    private List<ACGroup> getGroups() {
        ArrayList<ACOrgUnit> allGroups = new ArrayList<ACOrgUnit>();
        ArrayList<ACGroup> groups = new ArrayList<ACGroup>();
        try {
            allGroups.addAll(this.getAdminBroker().getGroups());
            ArrayList groupsToRemove = new ArrayList();
            groupsToRemove.addAll(this.getAdminBroker().getGroups(this.user.getId()));
            allGroups.removeAll(groupsToRemove);
            Object[] result = this.showDialog(allGroups, "Select a group");
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ACGroup) {
                    groups.add((ACGroup)result[i]);
                }
                ++i;
            }
        }
        catch (ESException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        return groups;
    }

    @Override
    protected void createTableGroup() {
        super.createTableGroup("Groups");
    }

    @Override
    public void updateControls(EObject input) {
        if (input != null && input instanceof ACUser) {
            this.user = (ACUser)input;
            this.getTxtName().setText(this.user.getName());
            this.getTxtDescription().setText(this.user.getDescription() == null ? "" : this.user.getDescription());
            this.getTableViewer().setInput((Object)this.user);
            String superUserName = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
            if (this.user.getName().equals(superUserName)) {
                this.getTxtName().setEnabled(false);
                this.getTxtDescription().setEnabled(false);
            } else {
                this.getTxtName().setEnabled(true);
                this.getTxtDescription().setEnabled(true);
            }
        }
    }

    @Override
    protected void addDragNDropSupport() {
        super.addDragNDropSupport();
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = PropertiesForm.getDragSource().equals("Projects") || PropertiesForm.getDragSource().equals("Users") ? 0 : 1;
            }

            public void drop(DropTargetEvent event) {
                if (PropertiesForm.getDragNDropObject() != null && PropertiesForm.getDragNDropObject() instanceof ACGroup) {
                    ACGroup group = (ACGroup)PropertiesForm.getDragNDropObject();
                    UserComposite.this.addExistingOrgUnit((ACOrgUnit)group);
                    PropertiesForm.setDragNDropObject(null);
                    UserComposite.this.getTableViewer().refresh();
                }
            }
        };
        this.getTableViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    @Override
    protected void saveOrgUnitAttributes() {
        if (this.getTxtName() == null || this.getTxtDescription() == null) {
            return;
        }
        if (this.user == null) {
            return;
        }
        String superUserName = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
        if (this.getTxtName().getText().compareToIgnoreCase(superUserName) == 0) {
            this.getTxtName().setText("New User");
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Illegal User Name!!!", (String)"The username \"super\" is not allowed! It was set to a default value. ");
            return;
        }
        if (this.getTxtName().getText().equals("")) {
            this.getTxtName().setText("New User");
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Empty User Name!!!", (String)"Empty usernames are not allowed! It was set to a default value.");
            return;
        }
        if (!this.user.getName().equals(this.getTxtName().getText()) || !this.user.getDescription().equals(this.getTxtDescription().getText())) {
            try {
                this.getAdminBroker().changeOrgUnit(this.user.getId(), this.getTxtName().getText(), this.getTxtDescription().getText());
                ((Form)this.getParent().getParent()).setText("User: " + this.getTxtName().getText());
                this.orgUnitMgmtGUI.getActiveTabContent().getTableViewer().refresh();
            }
            catch (ESException e) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        }
    }
}

