/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.testers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.observers.SaveStateChangedObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.ui.AbstractSourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESLocalProjectPropertySourceProvider
extends AbstractSourceProvider {
    public static final String CURRENT_SAVE_STATE_PROPERTY = "org.eclipse.emf.emfstore.client.ui.currentProjectSpaceSaveState";
    private SaveStateChangedObserver saveStateChangedObserver;
    private Map<String, Boolean> currentSaveStates = new LinkedHashMap<String, Boolean>();

    public ESLocalProjectPropertySourceProvider() {
        try {
            ESWorkspaceProviderImpl.init();
        }
        catch (RuntimeException exception) {
            ModelUtil.logException((String)"ProjectSpacePropertySourceProvider init failed because workspace init failed with exception.", (Throwable)exception);
            return;
        }
        this.saveStateChangedObserver = new SaveStateChangedObserver(){

            public void saveStateChanged(ESLocalProject localProject, boolean hasUnsavedChangesNow) {
                Boolean newValue = new Boolean(hasUnsavedChangesNow);
                ESLocalProjectPropertySourceProvider.this.currentSaveStates.put(localProject.getLastUpdated().toString(), newValue);
                ESLocalProjectPropertySourceProvider.this.fireSourceChanged(0, ESLocalProjectPropertySourceProvider.CURRENT_SAVE_STATE_PROPERTY, newValue);
            }
        };
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.saveStateChangedObserver);
    }

    public void dispose() {
        if (this.saveStateChangedObserver != null) {
            ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.saveStateChangedObserver);
        }
    }

    public Map<String, Object> getCurrentState() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(CURRENT_SAVE_STATE_PROPERTY, this.currentSaveStates);
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CURRENT_SAVE_STATE_PROPERTY};
    }
}

