/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.impl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.model.internal.reporting.LogConsumer;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.report.ReportServiceConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.view.model";
    private static Activator plugin;
    private ServiceReference<ReportService> reportServiceReference;
    private ServiceRegistration<ReportServiceConsumer> registerLogConsumerService;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LogConsumer logConsumer = new LogConsumer();
        this.registerLogConsumerService = context.registerService(ReportServiceConsumer.class, (Object)logConsumer, null);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.registerLogConsumerService.unregister();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
    }

    public static void logMessage(int severity, String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(severity, Activator.getDefault().getBundle().getSymbolicName(), message));
    }

    public static void log(AbstractReport report) {
        Activator.getDefault().getLog().log((IStatus)new Status(report.getSeverity(), PLUGIN_ID, report.getMessage(), report.getException()));
    }

    public ReportService getReportService() {
        if (this.reportServiceReference == null) {
            this.reportServiceReference = plugin.getBundle().getBundleContext().getServiceReference(ReportService.class);
        }
        return (ReportService)plugin.getBundle().getBundleContext().getService(this.reportServiceReference);
    }
}

