/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.module;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emfcloud.jackson.annotations.EcoreIdentityInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreReferenceInfo;
import org.eclipse.emfcloud.jackson.annotations.EcoreTypeInfo;
import org.eclipse.emfcloud.jackson.databind.FeatureMapEntryConfig;
import org.eclipse.emfcloud.jackson.databind.deser.EMFDeserializers;
import org.eclipse.emfcloud.jackson.databind.deser.EcoreReferenceDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.FeatureMapEntryDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.ser.EMFSerializers;
import org.eclipse.emfcloud.jackson.databind.ser.EcoreReferenceSerializer;
import org.eclipse.emfcloud.jackson.databind.ser.FeatureMapEntrySerializer;
import org.eclipse.emfcloud.jackson.databind.ser.NullKeySerializer;
import org.eclipse.emfcloud.jackson.handlers.BaseURIHandler;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;

public class EMFModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private EcoreReferenceInfo referenceInfo;
    private EcoreTypeInfo typeInfo;
    private EcoreIdentityInfo identityInfo;
    private JsonSerializer<EObject> referenceSerializer;
    private JsonDeserializer<ReferenceEntry> referenceDeserializer;
    private JsonSerializer<FeatureMap.Entry> featureMapEntrySerializer;
    private JsonDeserializer<FeatureMap.Entry> featureMapEntryDeserializer;
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int moduleFeatures = DEFAULT_FEATURES;
    private URIHandler handler;

    public void setTypeInfo(EcoreTypeInfo info) {
        this.typeInfo = info;
    }

    public void setIdentityInfo(EcoreIdentityInfo identityInfo) {
        this.identityInfo = identityInfo;
    }

    public void setReferenceInfo(EcoreReferenceInfo referenceInfo) {
        this.referenceInfo = referenceInfo;
    }

    public void setReferenceSerializer(JsonSerializer<EObject> serializer) {
        this.referenceSerializer = serializer;
    }

    public JsonSerializer<EObject> getReferenceSerializer() {
        return this.referenceSerializer;
    }

    public void setReferenceDeserializer(JsonDeserializer<ReferenceEntry> deserializer) {
        this.referenceDeserializer = deserializer;
    }

    public JsonDeserializer<ReferenceEntry> getReferenceDeserializer() {
        return this.referenceDeserializer;
    }

    public void setFeatureMapEntrySerializer(JsonSerializer<FeatureMap.Entry> serializer) {
        this.featureMapEntrySerializer = serializer;
    }

    public JsonSerializer<FeatureMap.Entry> getFeatureMapEntrySerializer() {
        return this.featureMapEntrySerializer;
    }

    public void setFeatureMapEntryDeserializer(JsonDeserializer<FeatureMap.Entry> deserializer) {
        this.featureMapEntryDeserializer = deserializer;
    }

    public JsonDeserializer<FeatureMap.Entry> getFeatureMapEntryDeserializer() {
        return this.featureMapEntryDeserializer;
    }

    public static ObjectMapper setupDefaultMapper() {
        return EMFModule.setupDefaultMapper(null);
    }

    public static ObjectMapper setupDefaultMapper(JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getDefault());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setDateFormat((DateFormat)dateFormat);
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.registerModule((Module)new EMFModule());
        mapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        return mapper;
    }

    public void setupModule(Module.SetupContext context) {
        if (this.handler == null) {
            this.handler = new BaseURIHandler();
        }
        if (this.typeInfo == null) {
            this.typeInfo = new EcoreTypeInfo();
        }
        if (this.identityInfo == null) {
            this.identityInfo = new EcoreIdentityInfo();
        }
        if (this.referenceInfo == null) {
            this.referenceInfo = new EcoreReferenceInfo(this.handler);
        }
        if (this.referenceSerializer == null) {
            this.referenceSerializer = new EcoreReferenceSerializer(this.referenceInfo, this.typeInfo);
        }
        if (this.referenceDeserializer == null) {
            this.referenceDeserializer = new EcoreReferenceDeserializer(this.referenceInfo, this.typeInfo);
        }
        if (this.featureMapEntrySerializer == null) {
            this.featureMapEntrySerializer = new FeatureMapEntrySerializer(this.referenceSerializer, new FeatureMapEntryConfig(this.getFeatures()));
        }
        if (this.featureMapEntryDeserializer == null) {
            this.featureMapEntryDeserializer = new FeatureMapEntryDeserializer(new FeatureMapEntryConfig(this.getFeatures()));
        }
        EMFDeserializers deserializers = new EMFDeserializers(this);
        EMFSerializers serializers = new EMFSerializers(this);
        context.addDeserializers((Deserializers)deserializers);
        context.addSerializers((Serializers)serializers);
        super.setupModule(context);
    }

    public String getModuleName() {
        return "emfjson-module";
    }

    public Version version() {
        return new Version(1, 0, 0, "rc1", "org.eclipse.emfcloud", "emfjson-jackson");
    }

    private EMFModule enable(Feature f) {
        this.moduleFeatures |= f.getMask();
        return this;
    }

    private EMFModule disable(Feature f) {
        this.moduleFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this.moduleFeatures & f.getMask()) != 0;
    }

    public int getFeatures() {
        return this.moduleFeatures;
    }

    public EMFModule configure(Feature feature, boolean state) {
        if (state) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public void setUriHandler(URIHandler handler) {
        this.handler = handler;
    }

    public URIHandler getUriHandler() {
        return this.handler;
    }

    public EcoreIdentityInfo getIdentityInfo() {
        return this.identityInfo;
    }

    public EcoreTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public EcoreReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public static enum Feature {
        OPTION_USE_ID(false),
        OPTION_SERIALIZE_TYPE(true),
        OPTION_MINIMIZE_TYPE_INFO(true),
        OPTION_SERIALIZE_DEFAULT_VALUE(false),
        OPTION_USE_NAMES_FROM_EXTENDED_META_DATA(true),
        OPTION_USE_FEATURE_MAP_KEY_AND_VALUE_PROPERTIES(false);

        private final boolean defaultState;
        private final int mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(Boolean defaultState) {
            this.defaultState = defaultState;
            this.mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this.mask) != 0;
        }

        public boolean enabledByDefault() {
            return this.defaultState;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

