/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.cross.riscv;

import ilg.gnumcueclipse.managedbuild.cross.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ToolchainDefinition
extends ilg.gnumcueclipse.managedbuild.cross.ToolchainDefinition {
    public static final String XPACK_RISCV_GCC = "xPack GNU RISC-V Embedded GCC";
    public static final String GME_RISCV_GCC = "GNU MCU RISC-V GCC";
    public static final String RISC_V_GCC_NEWLIB = "RISC-V GCC/Newlib";
    public static final String RISC_V_GCC_LINUX = "RISC-V GCC/Linux";
    public static final String RISC_V_GCC_RTEMS = "RISC-V GCC/RTEMS";
    public static final String DEFAULT_TOOLCHAIN_NAME = "xPack GNU RISC-V Embedded GCC";
    protected static List<ToolchainDefinition> fgList = new ArrayList<ToolchainDefinition>();
    protected static String[] fgArchitectures = new String[]{"RISC-V"};
    private static final String CUSTOM_TOOLCHAINS_EXT_POINT_ID = "ilg.gnumcueclipse.managedbuild.cross.toolchains";

    static {
        ToolchainDefinition.addToolchain(new ToolchainDefinition("xPack GNU RISC-V Embedded GCC", "riscv-none-embed-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(GME_RISCV_GCC, "riscv-none-embed-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(RISC_V_GCC_NEWLIB, "riscv64-unknown-elf-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(RISC_V_GCC_LINUX, "riscv64-unknown-linux-gnu-"));
        ToolchainDefinition.addToolchain(new ToolchainDefinition(RISC_V_GCC_RTEMS, "riscv64-unknown-rtems-"));
        ToolchainDefinition.addExtensionsToolchains(CUSTOM_TOOLCHAINS_EXT_POINT_ID);
    }

    public ToolchainDefinition(String sName) {
        super(sName);
        this.fArchitecture = "risc-v";
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this(sName);
        this.fPrefix = sPrefix;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.fArchitecture = sArchitecture;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public static List<ToolchainDefinition> getList() {
        return fgList;
    }

    public static ToolchainDefinition getToolchain(int index) {
        return fgList.get(index);
    }

    public static ToolchainDefinition getToolchain(String index) {
        return fgList.get(Integer.parseInt(index));
    }

    public static int getSize() {
        return fgList.size();
    }

    public static void addToolchain(ToolchainDefinition toolchain) {
        fgList.add(toolchain);
    }

    public static int findToolchainByName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.fName.equals(sName)) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int findToolchainByFullName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            String sFullName = td.getFullName();
            if (sFullName.equals(sName)) {
                return i;
            }
            ++i;
        }
        return ToolchainDefinition.getDefault();
    }

    public static int getDefault() {
        return 0;
    }

    public static String[] getArchitectures() {
        return fgArchitectures;
    }

    public static String getArchitecture(int index) {
        return fgArchitectures[index];
    }

    public static void addExtensionsToolchains(String extensionPointId) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getAttribute("name");
            try {
                ToolchainDefinition.findToolchainByName(name);
                Activator.log((String)("Duplicate toolchain name '" + name + "', ignored."));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                String cmdRm;
                String cmdMake;
                String architecture;
                String suffix;
                ToolchainDefinition td = new ToolchainDefinition(name);
                String prefix = element.getAttribute("prefix");
                if (prefix != null && !prefix.isEmpty()) {
                    td.setPrefix(prefix);
                }
                if ((suffix = element.getAttribute("suffix")) != null && !suffix.isEmpty()) {
                    td.setSuffix(suffix);
                }
                if ((architecture = element.getAttribute("architecture")) != null && !architecture.isEmpty()) {
                    td.setArchitecture(architecture);
                }
                if ((cmdMake = element.getAttribute("make_cmd")) != null && !cmdMake.isEmpty()) {
                    td.setCmdMake(cmdMake);
                }
                if ((cmdRm = element.getAttribute("remove_cmd")) != null && !cmdRm.isEmpty()) {
                    td.setCmdRm(cmdRm);
                }
                fgList.add(td);
            }
            ++n2;
        }
    }
}

