/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.team.core.history.IFileRevision;

public class SymlinkEditableRevision
extends EditableRevision {
    private final IPath location;
    private final IRunnableContext runnableContext;

    public SymlinkEditableRevision(IFileRevision fileRevision, @NonNull IPath location, @NonNull IRunnableContext runnableContext) {
        super(fileRevision, null);
        this.location = location;
        this.runnableContext = runnableContext;
    }

    @Override
    public void setContent(byte[] newContent) {
        try {
            IFile ourFile;
            ISchedulingRule rule = Job.getJobManager().currentRule();
            boolean fork = true;
            if (rule instanceof IResource && (ourFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.location)).exists() && ((IResource)rule).isConflicting((ISchedulingRule)ourFile)) {
                fork = false;
            }
            this.runnableContext.run(fork, false, monitor -> {
                int eol = RawParseUtils.nextLF((byte[])newContent, (int)0);
                String target = new String(newContent, 0, eol, StandardCharsets.UTF_8).trim();
                try {
                    File linkFile = this.location.toFile();
                    boolean wasBrokenLink = !linkFile.exists();
                    Path link = FileUtils.createSymLink((File)linkFile, (String)target);
                    this.updateLinkResource(wasBrokenLink, link);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            });
            this.fireContentChanged();
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void updateLinkResource(boolean wasBroken, Path link) {
        boolean brokenNow;
        boolean bl = brokenNow = !Files.exists(link, new LinkOption[0]);
        if (brokenNow == wasBroken) {
            return;
        }
        IPath parentPath = this.location.removeLastSegments(1);
        final IContainer parent = ResourceUtil.getContainerForLocation((IPath)parentPath, (boolean)true);
        if (parent != null) {
            WorkspaceJob job = new WorkspaceJob("Refreshing " + String.valueOf(parentPath)){

                public IStatus runInWorkspace(IProgressMonitor m) throws CoreException {
                    parent.refreshLocal(1, m);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.location, this.runnableContext);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        SymlinkEditableRevision other = (SymlinkEditableRevision)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.runnableContext, other.runnableContext);
    }
}

