/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;

public class RepositoryMapping {
    private final String containerPathString;
    private IPath containerPath;
    private final String gitDirPathString;
    private IPath gitDirPath;
    private IPath gitDirAbsolutePath;
    private Repository db;
    private String workdirPrefix;
    private IContainer container;

    static boolean isInitialKey(String key) {
        return key.endsWith(".gitdir");
    }

    public RepositoryMapping(@NonNull Properties p, @NonNull String initialKey) {
        int dot = initialKey.lastIndexOf(46);
        this.containerPathString = initialKey.substring(0, dot);
        this.gitDirPathString = p.getProperty(initialKey);
    }

    @Nullable
    public static RepositoryMapping create(@NonNull IContainer mappedContainer, @NonNull File gitDir) {
        IPath location = mappedContainer.getLocation();
        if (location == null) {
            return null;
        }
        return new RepositoryMapping(mappedContainer, location, gitDir);
    }

    private RepositoryMapping(@NonNull IContainer mappedContainer, @NonNull IPath location, @NonNull File gitDir) {
        this.container = mappedContainer;
        this.containerPathString = this.container.getProjectRelativePath().toPortableString();
        if (!gitDir.isAbsolute()) {
            this.gitDirPathString = Path.fromOSString((String)gitDir.getPath()).removeTrailingSeparator().toPortableString();
            return;
        }
        java.nio.file.Path gPath = gitDir.toPath();
        java.nio.file.Path lPath = location.toFile().toPath();
        if (lPath.getNameCount() > 0 && gPath.getNameCount() > 0 && (gPath.getRoot() == lPath.getRoot() || gPath.getRoot() != null && gPath.getRoot().equals(lPath.getRoot())) && gPath.getName(0).equals(lPath.getName(0))) {
            gPath = lPath.relativize(gPath);
        }
        this.gitDirPathString = Path.fromOSString((String)gPath.toString()).removeTrailingSeparator().toPortableString();
    }

    @NonNull
    public IPath getContainerPath() {
        if (this.containerPath == null) {
            this.containerPath = Path.fromPortableString((String)this.containerPathString);
        }
        return this.containerPath;
    }

    @NonNull
    IPath getGitDirPath() {
        if (this.gitDirPath == null) {
            this.gitDirPath = Path.fromPortableString((String)this.gitDirPathString);
        }
        return this.gitDirPath;
    }

    @Nullable
    public File getWorkTree() {
        Repository repo = this.getRepository();
        if (repo.isBare()) {
            return null;
        }
        return repo.getWorkTree();
    }

    synchronized void clear() {
        this.db = null;
        this.workdirPrefix = null;
        this.container = null;
    }

    public synchronized Repository getRepository() {
        return this.db;
    }

    synchronized void setRepository(Repository r) {
        this.db = r;
        File workTree = this.getWorkTree();
        if (workTree == null) {
            return;
        }
        this.workdirPrefix = workTree.getAbsolutePath();
        this.workdirPrefix = this.workdirPrefix.replace('\\', '/');
        if (!this.workdirPrefix.endsWith("/")) {
            this.workdirPrefix = String.valueOf(this.workdirPrefix) + "/";
        }
    }

    public synchronized IContainer getContainer() {
        return this.container;
    }

    synchronized void setContainer(IContainer c) {
        this.container = c;
    }

    synchronized void store(Properties p) {
        p.setProperty(this.containerPathString + ".gitdir", this.gitDirPathString);
    }

    public String toString() {
        IPath absolutePath = this.getGitDirAbsolutePath();
        return "RepositoryMapping[" + this.format(this.containerPathString) + " -> '" + this.format(this.gitDirPathString) + "', absolute path: '" + this.format(absolutePath) + "' ]";
    }

    private String format(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o.toString().length() == 0) {
            return "<empty>";
        }
        return o.toString();
    }

    @Nullable
    public String getRepoRelativePath(@NonNull IResource rsrc) {
        IPath location = rsrc.getLocation();
        if (location == null) {
            return null;
        }
        return this.getRepoRelativePath(location);
    }

    @Nullable
    public synchronized String getRepoRelativePath(@NonNull IPath location) {
        if (this.workdirPrefix == null) {
            return null;
        }
        int pfxLen = this.workdirPrefix.length();
        String p = location.toString();
        int pLen = p.length();
        if (pLen > pfxLen) {
            return p.substring(pfxLen);
        }
        if (pLen == pfxLen - 1) {
            return "";
        }
        return null;
    }

    @Nullable
    public static RepositoryMapping getMapping(@NonNull IResource resource) {
        if (ResourceUtil.isNonWorkspace(resource)) {
            return null;
        }
        if (resource.isLinked(512)) {
            IPath location = resource.getLocation();
            if (location == null) {
                return null;
            }
            return RepositoryMapping.getMapping(location);
        }
        return RepositoryMapping.findMapping(resource);
    }

    @Nullable
    public static RepositoryMapping getMapping(@Nullable IProject project) {
        if (project == null) {
            return null;
        }
        return RepositoryMapping.findMapping((IResource)project);
    }

    @Nullable
    private static GitProjectData getProjectData(@Nullable IProject project) {
        GitProjectData data;
        if (project == null || ResourceUtil.isNonWorkspace((IResource)project)) {
            return null;
        }
        GitProvider rp = ResourceUtil.getGitProvider(project);
        if (rp == null) {
            data = GitProjectData.get(project);
            if (data == null) {
                return null;
            }
        } else {
            data = rp.getData();
        }
        return data;
    }

    @Nullable
    private static RepositoryMapping findMapping(@NonNull IResource resource) {
        GitProjectData data = RepositoryMapping.getProjectData(resource.getProject());
        if (data == null) {
            return null;
        }
        return data.getRepositoryMapping(resource);
    }

    @NonNull
    private static Map<IPath, RepositoryMapping> getMappings(@Nullable IProject project) {
        GitProjectData data = RepositoryMapping.getProjectData(project);
        if (data == null) {
            return Collections.emptyMap();
        }
        return data.getRepositoryMappings();
    }

    @Nullable
    public static RepositoryMapping getMapping(@NonNull IPath path) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Path bestWorkingTree = null;
        RepositoryMapping bestMapping = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!ResourceUtil.isNonWorkspace((IResource)project)) {
                for (RepositoryMapping mapping : RepositoryMapping.getMappings(project).values()) {
                    Path workingTree;
                    File workTree = mapping.getWorkTree();
                    if (workTree == null || !(workingTree = new Path(workTree.toString())).isPrefixOf(path) || bestWorkingTree != null && workingTree.segmentCount() <= bestWorkingTree.segmentCount()) continue;
                    bestWorkingTree = workingTree;
                    bestMapping = mapping;
                }
            }
            ++n2;
        }
        return bestMapping;
    }

    @Nullable
    public static RepositoryMapping findRepositoryMapping(@NonNull Repository repository) {
        IProject[] iProjectArray = ProjectUtil.getProjectsUnderPath((IPath)new Path(repository.getWorkTree().getAbsolutePath()));
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping(project);
            if (mapping != null && mapping.getRepository() == repository) {
                return mapping;
            }
            ++n2;
        }
        return null;
    }

    public String getGitDir() {
        return this.gitDirPathString;
    }

    @Nullable
    public synchronized IPath getGitDirAbsolutePath() {
        if (this.gitDirAbsolutePath == null) {
            IPath cloc;
            IPath p = this.getGitDirPath();
            if (p.isAbsolute()) {
                this.gitDirAbsolutePath = p;
            } else if (this.container != null && (cloc = this.container.getLocation()) != null) {
                this.gitDirAbsolutePath = cloc.append(p);
            }
        }
        return this.gitDirAbsolutePath;
    }
}

