/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DevelopCompareHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String revision;
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return Activator.error(UIText.Handlers_noGitflowRepositoryFound);
        }
        IResource[] selectedResources = GitFlowHandlerUtil.gatherResourceToOperateOn(event);
        try {
            revision = GitFlowHandlerUtil.gatherRevision(event);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            CompareUtils.compare((IResource[])selectedResources, (Repository)gfRepo.getRepository(), (String)"HEAD", (String)revision, (boolean)true, (IWorkbenchPage)workbenchPage);
        }
        catch (IOException e) {
            org.eclipse.egit.ui.Activator.handleError((String)org.eclipse.egit.ui.internal.UIText.CompareWithRefAction_errorOnSynchronize, (Throwable)e, (boolean)true);
        }
        return null;
    }
}

