/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.internal.signing.ssh.SshCertificateUtils;
import org.eclipse.jgit.internal.signing.ssh.SshSignatureConstants;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.signing.ssh.CachingSigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.SigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.VerificationException;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSignatureVerifier
implements SignatureVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(SshSignatureVerifier.class);
    private static final byte[] OBJECT = new byte[]{111, 98, 106, 101, 99, 116, 32};
    private static final byte[] TREE = new byte[]{116, 114, 101, 101, 32};
    private static final byte[] TYPE = new byte[]{116, 121, 112, 101, 32};

    public String getName() {
        return "ssh";
    }

    public SignatureVerifier.SignatureVerification verify(Repository repository, GpgConfig config, byte[] data, byte[] signatureData) throws IOException {
        boolean valid;
        String signatureAlgorithm;
        byte[] hash;
        String namespace;
        String fingerprint;
        byte[] decodedSignature;
        PersonIdent gitIdentity = SshSignatureVerifier.getGitIdentity(data);
        Date signatureDate = null;
        Instant signatureInstant = null;
        if (gitIdentity != null) {
            signatureDate = gitIdentity.getWhen();
            signatureInstant = gitIdentity.getWhenAsInstant();
        }
        SignatureVerifier.TrustLevel trust = SignatureVerifier.TrustLevel.NEVER;
        try {
            decodedSignature = SshSignatureVerifier.dearmor(signatureData);
        }
        catch (IllegalArgumentException e) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidSignature, e.getLocalizedMessage()));
        }
        int start = RawParseUtils.match((byte[])decodedSignature, (int)0, (byte[])SshSignatureConstants.MAGIC);
        if (start < 0) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, SshdText.get().signInvalidMagic);
        }
        ByteArrayBuffer signature = new ByteArrayBuffer(decodedSignature, start, decodedSignature.length - start);
        long version = signature.getUInt();
        if (version != 1L) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, null, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidVersion, Long.toString(version)));
        }
        PublicKey key = signature.getPublicKey();
        if (key instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key;
            fingerprint = KeyUtils.getFingerPrint((PublicKey)cert.getCertPubKey());
            String message = SshCertificateUtils.verify(cert, signatureInstant);
            if (message != null) {
                return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, message);
            }
        } else {
            fingerprint = KeyUtils.getFingerPrint((PublicKey)key);
        }
        if (!"git".equals(namespace = signature.getString())) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidNamespace, namespace));
        }
        signature.getString();
        String hashAlgorithm = signature.getString();
        try {
            hash = MessageDigest.getInstance(hashAlgorithm.toUpperCase(Locale.ROOT)).digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signUnknownHashAlgorithm, hashAlgorithm));
        }
        ByteArrayBuffer rawSignature = new ByteArrayBuffer(signature.getBytes());
        if (signature.available() > 0) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, SshdText.get().signGarbageAtEnd);
        }
        switch (signatureAlgorithm = rawSignature.getString()) {
            case "ssh-dss": 
            case "ssh-rsa": 
            case "ssh-rsa-cert-v01@openssh.com": 
            case "ssh-dss-cert-v01@openssh.com": {
                return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signInvalidAlgorithm, signatureAlgorithm));
            }
        }
        String keyType = KeyUtils.getSignatureAlgorithm((String)KeyUtils.getKeyType((Key)key), (PublicKey)key);
        if (!KeyUtils.getCanonicalKeyType((String)keyType).equals(KeyUtils.getCanonicalKeyType((String)signatureAlgorithm))) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signMismatchedSignatureAlgorithm, keyType, signatureAlgorithm));
        }
        BuiltinSignatures factory = BuiltinSignatures.fromFactoryName((String)signatureAlgorithm);
        if (factory == null || !factory.isSupported()) {
            return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, null, false, false, trust, MessageFormat.format(SshdText.get().signUnknownSignatureAlgorithm, signatureAlgorithm));
        }
        String message = null;
        try {
            PublicKey publicKey;
            Signature verifier = (Signature)factory.create();
            if (key instanceof OpenSshCertificate) {
                OpenSshCertificate cert = (OpenSshCertificate)key;
                publicKey = cert.getCertPubKey();
            } else {
                publicKey = key;
            }
            verifier.initVerifier(null, publicKey);
            ByteArrayBuffer toSign = new ByteArrayBuffer();
            toSign.putRawBytes(SshSignatureConstants.MAGIC);
            toSign.putString("git");
            toSign.putUInt(0L);
            toSign.putString(hashAlgorithm);
            toSign.putBytes(hash);
            verifier.update(null, toSign.getCompactData());
            valid = verifier.verify(null, rawSignature.getBytes());
        }
        catch (Exception e) {
            LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e);
            valid = false;
            message = SshdText.get().signSeeLog;
        }
        boolean expired = false;
        String principal = null;
        if (valid) {
            if (rawSignature.available() > 0) {
                valid = false;
                message = SshdText.get().signGarbageAtEnd;
            } else {
                SigningKeyDatabase database = SigningKeyDatabase.getInstance();
                if (database.isRevoked(repository, config, key)) {
                    valid = false;
                    if (key instanceof OpenSshCertificate) {
                        OpenSshCertificate certificate = (OpenSshCertificate)key;
                        message = MessageFormat.format(SshdText.get().signCertificateRevoked, KeyUtils.getFingerPrint((PublicKey)certificate.getCaPubKey()));
                    } else {
                        message = SshdText.get().signKeyRevoked;
                    }
                } else {
                    try {
                        principal = database.isAllowed(repository, config, key, "git", gitIdentity);
                        if (!StringUtils.isEmptyOrNull((String)principal)) {
                            trust = SignatureVerifier.TrustLevel.FULL;
                        } else {
                            valid = false;
                            message = SshdText.get().signNoPrincipalMatched;
                            trust = SignatureVerifier.TrustLevel.UNKNOWN;
                        }
                    }
                    catch (VerificationException e) {
                        valid = false;
                        message = e.getMessage();
                        expired = e.isExpired();
                    }
                    catch (IOException e) {
                        LOG.warn("{}", (Object)SshdText.get().signLogFailure, (Object)e);
                        valid = false;
                        message = SshdText.get().signSeeLog;
                    }
                }
            }
        }
        return new SignatureVerifier.SignatureVerification(this.getName(), signatureDate, null, fingerprint, principal, valid, expired, trust, message);
    }

    private static PersonIdent getGitIdentity(byte[] rawObject) {
        int i = RawParseUtils.match((byte[])rawObject, (int)0, (byte[])TREE);
        if (i > 0) {
            i = RawParseUtils.committer((byte[])rawObject, (int)0);
            if (i < 0) {
                return null;
            }
            return RawParseUtils.parsePersonIdent((byte[])rawObject, (int)i);
        }
        i = RawParseUtils.match((byte[])rawObject, (int)0, (byte[])OBJECT);
        if (i > 0) {
            i = RawParseUtils.nextLF((byte[])rawObject, (int)i);
            if ((i = RawParseUtils.match((byte[])rawObject, (int)i, (byte[])TYPE)) > 0) {
                i = RawParseUtils.tagger((byte[])rawObject, (int)0);
                if (i < 0) {
                    return null;
                }
                return RawParseUtils.parsePersonIdent((byte[])rawObject, (int)i);
            }
        }
        return null;
    }

    private static byte[] dearmor(byte[] data) {
        int end;
        int start = RawParseUtils.match((byte[])data, (int)0, (byte[])SshSignatureConstants.ARMOR_HEAD);
        if (start > 0) {
            if (data[start] == 13) {
                ++start;
            }
            if (data[start] == 10) {
                ++start;
            }
        }
        if ((end = data.length) > start + 1 && data[end - 1] == 10 && --end > start + 1 && data[end - 1] == 13) {
            --end;
        }
        if ((end -= SshSignatureConstants.ARMOR_END.length) < 0 || end < start || RawParseUtils.match((byte[])data, (int)end, (byte[])SshSignatureConstants.ARMOR_END) < 0) {
            end = data.length;
        }
        if (start < 0) {
            start = 0;
        }
        return Base64.decode((byte[])data, (int)start, (int)(end - start));
    }

    public void clear() {
        SigningKeyDatabase database = SigningKeyDatabase.getInstance();
        if (database instanceof CachingSigningKeyDatabase) {
            CachingSigningKeyDatabase caching = (CachingSigningKeyDatabase)database;
            caching.clearCache();
        }
    }
}

