/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractFeatureOperation;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public final class FeatureStartOperation
extends AbstractFeatureOperation {
    private int timeoutInSeconds;

    public FeatureStartOperation(GitFlowRepository repository, String featureName, int timeout) {
        super(repository, featureName);
        this.timeoutInSeconds = timeout;
    }

    public FeatureStartOperation(GitFlowRepository repository, String featureName) {
        this(repository, featureName, -1);
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        GitFlowConfig config = this.repository.getConfig();
        if (config.isFetchOnFeatureStart()) {
            try {
                this.fetch((IProgressMonitor)progress.newChild(1), this.timeoutInSeconds);
            }
            catch (InvocationTargetException e) {
                throw new CoreException(Activator.error(e));
            }
        }
        progress.setWorkRemaining(1);
        this.handleDivergingDevelop(config);
        String branchName = config.getFeatureBranchName(this.featureName);
        RevCommit head = this.repository.findHead(config.getDevelop());
        if (head == null) {
            throw new IllegalStateException(NLS.bind((String)CoreText.StartOperation_unableToFindCommitFor, (Object)config.getDevelop()));
        }
        this.start((IProgressMonitor)progress.newChild(1), branchName, head);
    }

    private void handleDivergingDevelop(GitFlowConfig config) throws CoreException {
        try {
            BranchTrackingStatus developStatus = BranchTrackingStatus.of((Repository)this.repository.getRepository(), (String)config.getDevelop());
            if (developStatus == null) {
                return;
            }
            if (developStatus.getBehindCount() > 0) {
                String message = NLS.bind((String)CoreText.FeatureStartOperation_divergingDevelop, (Object)config.getDevelop(), (Object)this.getOriginDevelopName(developStatus));
                if (developStatus.getAheadCount() == 0) {
                    message = String.valueOf(message) + "\n" + NLS.bind((String)CoreText.FeatureStartOperation_andBranchMayBeFastForwarded, (Object)config.getDevelop());
                }
                throw new CoreException(Activator.error(message));
            }
            if (developStatus.getAheadCount() > 0) {
                String message = NLS.bind((String)CoreText.FeatureStartOperation_divergingDevelop, (Object)config.getDevelop(), (Object)this.getOriginDevelopName(developStatus));
                message = String.valueOf(message) + "\n" + NLS.bind((String)CoreText.FeatureStartOperation_andLocalDevelopIsAheadOfOrigin, (Object)config.getDevelop(), (Object)this.getOriginDevelopName(developStatus));
                Activator.logInfo(message);
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(e));
        }
    }

    private String getOriginDevelopName(BranchTrackingStatus developStatus) {
        return developStatus.getRemoteTrackingBranch().substring("refs/remotes/".length());
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

