/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.ide.rrobot.ProjectHandler;
import org.eclipse.fx.ide.rrobot.RRobot;
import org.eclipse.fx.ide.rrobot.model.task.Project;
import org.eclipse.fx.ide.rrobot.model.task.RobotTask;
import org.eclipse.fx.ide.rrobot.model.task.Variable;

public class RRobotImpl
implements RRobot {
    private List<ProjectHandler<Project>> handlers = new ArrayList<ProjectHandler<Project>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectHandler(ProjectHandler<Project> handler) {
        List<ProjectHandler<Project>> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectHandler(ProjectHandler<Project> handler) {
        List<ProjectHandler<Project>> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }

    private static Object getVariableData(Variable v) {
        switch (v.getType()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(v.getDefaultValue());
            }
            case DOUBLE: {
                return Double.parseDouble(v.getDefaultValue());
            }
            case INT: {
                return Integer.parseInt(v.getDefaultValue());
            }
        }
        return v.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus executeTask(IProgressMonitor monitor, RobotTask task, Map<String, Object> additionalData) {
        ArrayList<ProjectHandler<Project>> handlers;
        if (!task.getVariables().isEmpty()) {
            task = (RobotTask)EcoreUtil.copy((EObject)task);
        }
        System.err.println("ADDITIONAL: " + String.valueOf(additionalData));
        for (Variable v : task.getVariables()) {
            if (additionalData.containsKey(v.getKey())) continue;
            additionalData.put(v.getKey(), RRobotImpl.getVariableData(v));
        }
        for (Map.Entry<String, Object> e : additionalData.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            e.setValue(StrSubstitutor.replace((Object)((String)e.getValue()), additionalData));
        }
        List<ProjectHandler<Project>> list = this.handlers;
        synchronized (list) {
            handlers = new ArrayList<ProjectHandler<Project>>(this.handlers);
        }
        TreeIterator it = task.eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            for (EStructuralFeature f : eo.eClass().getEAllStructuralFeatures()) {
                Object object = eo.eGet(f);
                if (!(object instanceof String)) continue;
                eo.eSet(f, (Object)StrSubstitutor.replace((Object)object, additionalData));
            }
        }
        System.err.println("ADDITIONAL: " + String.valueOf(additionalData));
        ArrayList<IStatus> states = new ArrayList<IStatus>();
        for (Project p : task.getProjects()) {
            for (ProjectHandler projectHandler : handlers) {
                if (!projectHandler.isHandled(p.eClass())) continue;
                states.add(projectHandler.createProject(monitor, p, additionalData));
            }
        }
        return new MultiStatus("org.eclipse.fx.ide.rrobot", 0, states.toArray(new IStatus[0]), "Task executed", null);
    }
}

