/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.generator;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.CopyValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FactoryValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.IncludeValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceType;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptHandlerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueExpression;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueReference;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.fxgraph.generator.LanguageManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FXGraphGenerator
implements IGenerator {
    public String calculateRelativePath(Resource resource) {
        boolean _isPlatformResource = resource.getURI().isPlatformResource();
        if (_isPlatformResource) {
            String[] _segments;
            URI uri = resource.getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(uri.segment(1));
            Object projectRelativePath = "";
            int i = 0;
            String[] stringArray = _segments = uri.segments();
            int n = _segments.length;
            int n2 = 0;
            while (n2 < n) {
                String seg = stringArray[n2];
                if (i >= 1) {
                    String _segment = uri.segment(i);
                    String _plus = (String)projectRelativePath + "/" + _segment;
                    projectRelativePath = _plus;
                }
                ++i;
                ++n2;
            }
            int _length = project.getName().length();
            int _plus = _length + 2;
            String _substring = ((String)projectRelativePath).substring(_plus);
            String _plus_1 = "../" + _substring;
            projectRelativePath = _plus_1;
            return projectRelativePath;
        }
        return null;
    }

    public String doGeneratePreview(Resource resource, boolean skipController, boolean skipIncludes) {
        block3: {
            try {
                boolean _notEquals;
                String projectRelativePath = this.calculateRelativePath(resource);
                boolean bl = _notEquals = !Objects.equals(projectRelativePath, null);
                if (_notEquals) {
                    return this.createContent(resource, projectRelativePath, true, skipController, skipIncludes).toString();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block3;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        block3: {
            try {
                boolean _notEquals;
                String projectRelativePath = this.calculateRelativePath(resource);
                boolean bl = _notEquals = !Objects.equals(projectRelativePath, null);
                if (_notEquals) {
                    String relativeOutPath = projectRelativePath.replaceFirst(".fxgraph$", ".fxml");
                    fsa.generateFile(relativeOutPath, this.createContent(resource, projectRelativePath, false, false, false));
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block3;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public CharSequence createContent(Resource resource, String projectRelativePath, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        ImportManager importManager = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        LanguageManager languageManager = new LanguageManager();
        _builder.newLineIfNotEmpty();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<!-- ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Do not edit this file it is generated by e(fx)clipse from ");
        _builder.append(projectRelativePath, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("-->");
        _builder.newLine();
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)((EObject)resource.getContents().get(0)).eContents(), ComponentDefinition.class);
        for (ComponentDefinition rootElement : _filter) {
            boolean _notEquals;
            CharSequence body = this.componentDefinition(rootElement, importManager, languageManager, preview, skipController, skipIncludes);
            _builder.newLineIfNotEmpty();
            _builder.append("<?import java.lang.*?>");
            _builder.newLine();
            List _imports = importManager.getImports();
            for (String i : _imports) {
                _builder.append("<?import ");
                _builder.append(i);
                _builder.append("?>");
                _builder.newLineIfNotEmpty();
            }
            Collection<String> _languages = languageManager.getLanguages();
            for (String i_1 : _languages) {
                _builder.append("<?language ");
                _builder.append(i_1);
                _builder.append("?>");
                _builder.newLineIfNotEmpty();
            }
            EObject _get = (EObject)resource.getContents().get(0);
            String _previewResourceBundle = ((Model)_get).getComponentDef().getPreviewResourceBundle();
            boolean bl = _notEquals = !Objects.equals(_previewResourceBundle, null);
            if (_notEquals) {
                _builder.append("<?scenebuilder-preview-i18n-resource ");
                EObject _get_1 = (EObject)resource.getContents().get(0);
                String _previewResourceBundle_1 = ((Model)_get_1).getComponentDef().getPreviewResourceBundle();
                _builder.append(_previewResourceBundle_1);
                _builder.append("?>");
                _builder.newLineIfNotEmpty();
            }
            EObject _get_2 = (EObject)resource.getContents().get(0);
            EList<String> _previewCssFiles = ((Model)_get_2).getComponentDef().getPreviewCssFiles();
            for (String css : _previewCssFiles) {
                _builder.append("<?scenebuilder-stylesheet ");
                _builder.append(css);
                _builder.append("?>");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append((Object)body);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence componentDefinition(ComponentDefinition definition, ImportManager importManager, LanguageManager languageManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _isDynamicRoot_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        Element element = definition.getRootNode();
        _builder.newLineIfNotEmpty();
        boolean _isDynamicRoot = definition.isDynamicRoot();
        if (_isDynamicRoot) {
            boolean _hasAttributeProperties;
            _builder.append("<fx:root xmlns:fx=\"http://javafx.com/fxml\" type=\"");
            String _shortName = this.shortName(element.getType(), importManager);
            _builder.append(_shortName);
            _builder.append("\"");
            String _fxElementAttributes = this.fxElementAttributes(element, importManager, skipController);
            _builder.append(_fxElementAttributes);
            if (!Objects.equals(definition.getController(), null) && !skipController) {
                _builder.append(" fx:controller=\"");
                String _qualifiedName = definition.getController().getQualifiedName();
                _builder.append(_qualifiedName);
                _builder.append("\"");
            }
            if (_hasAttributeProperties = this.hasAttributeProperties(element, preview)) {
                StringBuilder _elementAttributes = this.elementAttributes((List<Property>)element.getProperties(), preview, skipController);
                _builder.append((Object)_elementAttributes);
                StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)element.getStaticProperties(), importManager, preview, skipController);
                _builder.append((Object)_elementStaticAttributes);
                StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)element.getStaticCallProperties(), importManager, preview, skipController);
                _builder.append((Object)_elementStaticCallAttributes);
            }
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasAttributeProperties_1;
            _builder.append("<");
            String _shortName_1 = this.shortName(element.getType(), importManager);
            _builder.append(_shortName_1);
            _builder.append(" xmlns:fx=\"http://javafx.com/fxml\"");
            String _fxElementAttributes_1 = this.fxElementAttributes(element, importManager, skipController);
            _builder.append(_fxElementAttributes_1);
            if (!Objects.equals(definition.getController(), null) && !skipController) {
                _builder.append(" fx:controller=\"");
                String _qualifiedName_1 = definition.getController().getQualifiedName();
                _builder.append(_qualifiedName_1);
                _builder.append("\"");
            }
            if (_hasAttributeProperties_1 = this.hasAttributeProperties(element, preview)) {
                StringBuilder _elementAttributes_1 = this.elementAttributes((List<Property>)element.getProperties(), preview, skipController);
                _builder.append((Object)_elementAttributes_1);
                StringBuilder _elementStaticAttributes_1 = this.elementStaticAttributes((List<StaticValueProperty>)element.getStaticProperties(), importManager, preview, skipController);
                _builder.append((Object)_elementStaticAttributes_1);
                StringBuilder _elementStaticCallAttributes_1 = this.elementStaticCallAttributes((List<StaticCallValueProperty>)element.getStaticCallProperties(), importManager, preview, skipController);
                _builder.append((Object)_elementStaticCallAttributes_1);
            }
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        int _size = definition.getDefines().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("<fx:define>");
            _builder.newLine();
            EList<Define> _defines = definition.getDefines();
            for (Define define : _defines) {
                boolean _notEquals_1;
                boolean _notEquals;
                Element _element = define.getElement();
                boolean bl2 = _notEquals = !Objects.equals(_element, null);
                if (_notEquals) {
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _elementContent = this.elementContent(define.getElement(), importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_elementContent, "\t\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                IncludeValueProperty _includeElement = define.getIncludeElement();
                boolean bl3 = _notEquals_1 = !Objects.equals(_includeElement, null);
                if (!_notEquals_1 || skipIncludes) continue;
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _includeContent = this.includeContent(define.getIncludeElement(), importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("</fx:define>");
            _builder.newLine();
        }
        if (!skipController) {
            EList<Script> _scripts = definition.getScripts();
            for (Script script : _scripts) {
                boolean _notEquals_2;
                _builder.append("\t");
                String _addLanguage = languageManager.addLanguage(script.getLanguage());
                _builder.append(_addLanguage, "\t");
                _builder.newLineIfNotEmpty();
                String _sourcecode = script.getSourcecode();
                boolean bl4 = _notEquals_2 = !Objects.equals(_sourcecode, null);
                if (_notEquals_2) {
                    _builder.append("\t");
                    _builder.append("<fx:script>");
                    String _sourcecode_1 = script.getSourcecode();
                    int _length = script.getSourcecode().length();
                    int _minus = _length - 2;
                    String _substring = _sourcecode_1.substring(2, _minus);
                    _builder.append(_substring, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("</fx:script>");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("<fx:script source=\"");
                String _source = script.getSource();
                _builder.append(_source, "\t");
                _builder.append("\"/>");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        boolean _hasNestedProperties = this.hasNestedProperties(element, preview);
        if (_hasNestedProperties) {
            EList<Element> _defaultChildren = element.getDefaultChildren();
            for (Element e : _defaultChildren) {
                _builder.append("\t");
                CharSequence _elementContent_1 = this.elementContent(e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            CharSequence _propContents = this.propContents((List<Property>)element.getProperties(), importManager, preview, false, skipController, skipIncludes);
            _builder.append((Object)_propContents, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)element.getStaticProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)element.getStaticCallProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
        }
        if (_isDynamicRoot_1 = definition.isDynamicRoot()) {
            _builder.append("</fx:root>");
            _builder.newLine();
        } else {
            _builder.append("</");
            String _shortName_2 = this.shortName(element.getType(), importManager);
            _builder.append(_shortName_2);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence elementContent(Element element, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _hasNestedProperties;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<");
        String _shortName = this.shortName(element.getType(), importManager);
        _builder.append(_shortName);
        String _fxElementAttributes = this.fxElementAttributes(element, importManager, skipController);
        _builder.append(_fxElementAttributes);
        boolean _hasAttributeProperties = this.hasAttributeProperties(element, preview);
        if (_hasAttributeProperties) {
            StringBuilder _elementAttributes = this.elementAttributes((List<Property>)element.getProperties(), preview, skipController);
            _builder.append((Object)_elementAttributes);
            StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)element.getStaticProperties(), importManager, preview, skipController);
            _builder.append((Object)_elementStaticAttributes);
            StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)element.getStaticCallProperties(), importManager, preview, skipController);
            _builder.append((Object)_elementStaticCallAttributes);
        }
        boolean bl = _not = !(_hasNestedProperties = this.hasNestedProperties(element, preview));
        if (_not) {
            _builder.append("/");
        }
        _builder.append("> ");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(element, preview);
        if (_hasNestedProperties_1) {
            EList<Element> _defaultChildren = element.getDefaultChildren();
            for (Element e : _defaultChildren) {
                _builder.append("\t");
                CharSequence _elementContent = this.elementContent(e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            CharSequence _propContents = this.propContents((List<Property>)element.getProperties(), importManager, preview, false, skipController, skipIncludes);
            _builder.append((Object)_propContents, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)element.getStaticProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)element.getStaticCallProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values = element.getValues();
            for (FactoryValueElement e_1 : _values) {
                if (e_1 instanceof Element) {
                    _builder.append("\t");
                    CharSequence _elementContent_1 = this.elementContent((Element)e_1, importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_elementContent_1, "\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (!(e_1 instanceof SimpleValueProperty)) continue;
                _builder.append("\t");
                String _objectLiteral = this.objectLiteral((SimpleValueProperty)e_1);
                _builder.append(_objectLiteral, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("</");
            String _shortName_1 = this.shortName(element.getType(), importManager);
            _builder.append(_shortName_1);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String objectLiteral(SimpleValueProperty value) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equals(_stringValue, null);
        if (_notEquals) {
            String _stringValue_1 = value.getStringValue();
            String _plus = "<String fx:value=\"" + _stringValue_1;
            return _plus + "\" />";
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equals(_booleanValue, null);
        if (_notEquals_1) {
            String _booleanValue_1 = value.getBooleanValue();
            String _plus_1 = "<Boolean fx:value=\"" + _booleanValue_1;
            return _plus_1 + "\" />";
        }
        if (!Objects.equals(value.getNumber(), null) && FXGraphGenerator.isIntNumber(value.getNumber())) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number = value.getNumber();
                String _plus_2 = "<Double fx:value=\"-" + _number;
                return _plus_2 + "\" />";
            }
            String _number_1 = value.getNumber();
            String _plus_3 = "<Double fx:value=\"" + _number_1;
            return _plus_3 + "\" />";
        }
        boolean _isNegative_1 = value.isNegative();
        if (_isNegative_1) {
            String _number_2 = value.getNumber();
            String _plus_4 = "<Integer fx:value=\"-" + _number_2;
            return _plus_4 + "\" />";
        }
        String _number_3 = value.getNumber();
        String _plus_5 = "<Integer fx:value=\"" + _number_3;
        return _plus_5 + "\" />";
    }

    public CharSequence propContents(List<Property> properties, ImportManager importManager, boolean preview, boolean simpleAsElement, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        if (simpleAsElement) {
            for (Property prop : properties) {
                CharSequence _propContent = this.propContent(prop, importManager, preview, simpleAsElement, skipController, skipIncludes);
                _builder.append((Object)_propContent);
                _builder.newLineIfNotEmpty();
            }
        } else {
            Functions.Function1 _function = p -> this.previewFilter((Property)p, preview);
            Functions.Function1 _function_1 = p -> this.subelementFilter((Property)p);
            Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
            for (Property prop_1 : _filter) {
                CharSequence _propContent_1 = this.propContent(prop_1, importManager, preview, simpleAsElement, skipController, skipIncludes);
                _builder.append((Object)_propContent_1);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence propContent(Property prop, ImportManager importManager, boolean preview, boolean simpleAsElement, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        ValueProperty _value = prop.getValue();
        if (_value instanceof SimpleValueProperty) {
            boolean _notEquals;
            ValueProperty _value_1 = prop.getValue();
            String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
            boolean bl = _notEquals = !Objects.equals(_stringValue, null);
            if (_notEquals) {
                _builder.append("<");
                String _name = prop.getName();
                _builder.append(_name);
                _builder.append(">");
                ValueProperty _value_2 = prop.getValue();
                String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                _builder.append(_stringValue_1);
                _builder.append("</");
                String _name_1 = prop.getName();
                _builder.append(_name_1);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
            } else if (simpleAsElement) {
                _builder.append("<");
                String _name_2 = prop.getName();
                _builder.append(_name_2);
                _builder.append(">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append(_simpleAttributeValue);
                _builder.append("</");
                String _name_3 = prop.getName();
                _builder.append(_name_3);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
            }
        } else {
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append("<");
                String _name_4 = prop.getName();
                _builder.append(_name_4);
                _builder.append("><");
                ValueProperty _value_5 = prop.getValue();
                String _shortName = this.shortName(((ConstValueProperty)_value_5).getType(), importManager);
                _builder.append(_shortName);
                _builder.append(" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append(_field);
                _builder.append("\" /></");
                String _name_5 = prop.getName();
                _builder.append(_name_5);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
            } else {
                ValueProperty _value_7 = prop.getValue();
                if (_value_7 instanceof ListValueProperty) {
                    _builder.append("<");
                    String _name_6 = prop.getName();
                    _builder.append(_name_6);
                    _builder.append(">");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    ValueProperty _value_8 = prop.getValue();
                    CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_propListContent, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("</");
                    String _name_7 = prop.getName();
                    _builder.append(_name_7);
                    _builder.append(">");
                    _builder.newLineIfNotEmpty();
                } else {
                    ValueProperty _value_9 = prop.getValue();
                    if (_value_9 instanceof MapValueProperty) {
                        _builder.append("<");
                        String _name_8 = prop.getName();
                        _builder.append(_name_8);
                        _builder.append(">");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        ValueProperty _value_10 = prop.getValue();
                        CharSequence _propContents = this.propContents((List<Property>)((MapValueProperty)_value_10).getProperties(), importManager, preview, true, skipController, skipIncludes);
                        _builder.append((Object)_propContents, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("</");
                        String _name_9 = prop.getName();
                        _builder.append(_name_9);
                        _builder.append(">");
                        _builder.newLineIfNotEmpty();
                    } else {
                        ValueProperty _value_11 = prop.getValue();
                        if (_value_11 instanceof Element) {
                            _builder.append("<");
                            String _name_10 = prop.getName();
                            _builder.append(_name_10);
                            _builder.append(">");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            ValueProperty _value_12 = prop.getValue();
                            CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                            _builder.append((Object)_elementContent, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("</");
                            String _name_11 = prop.getName();
                            _builder.append(_name_11);
                            _builder.append(">");
                            _builder.newLineIfNotEmpty();
                        } else {
                            ValueProperty _value_13 = prop.getValue();
                            if (_value_13 instanceof ReferenceValueProperty) {
                                if (!skipIncludes) {
                                    _builder.append("<");
                                    String _name_12 = prop.getName();
                                    _builder.append(_name_12);
                                    _builder.append(">");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t");
                                    ValueProperty _value_14 = prop.getValue();
                                    CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                                    _builder.append((Object)_referenceContent, "\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("</");
                                    String _name_13 = prop.getName();
                                    _builder.append(_name_13);
                                    _builder.append(">");
                                    _builder.newLineIfNotEmpty();
                                }
                            } else {
                                ValueProperty _value_15 = prop.getValue();
                                if (_value_15 instanceof IncludeValueProperty) {
                                    if (!skipIncludes) {
                                        _builder.append("<");
                                        String _name_14 = prop.getName();
                                        _builder.append(_name_14);
                                        _builder.append(">");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        ValueProperty _value_16 = prop.getValue();
                                        CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                                        _builder.append((Object)_includeContent, "\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("</");
                                        String _name_15 = prop.getName();
                                        _builder.append(_name_15);
                                        _builder.append(">");
                                        _builder.newLineIfNotEmpty();
                                    }
                                } else {
                                    ValueProperty _value_17 = prop.getValue();
                                    if (_value_17 instanceof CopyValueProperty) {
                                        _builder.append("<");
                                        String _name_16 = prop.getName();
                                        _builder.append(_name_16);
                                        _builder.append(">");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("\t");
                                        _builder.append("<fx:copy source=\"");
                                        ValueProperty _value_18 = prop.getValue();
                                        String _name_17 = ((CopyValueProperty)_value_18).getReference().getName();
                                        _builder.append(_name_17, "\t");
                                        _builder.append("\" />");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append("</");
                                        String _name_18 = prop.getName();
                                        _builder.append(_name_18);
                                        _builder.append(">");
                                        _builder.newLineIfNotEmpty();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence includeContent(IncludeValueProperty includeElement, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<fx:include");
        String _name = includeElement.getName();
        boolean bl = _notEquals = !Objects.equals(_name, null);
        if (_notEquals) {
            _builder.append(" fx:id=\"");
            String _name_1 = includeElement.getName();
            _builder.append(_name_1);
            _builder.append("\"");
        }
        _builder.append(" source=\"/");
        String _replaceAll = this.fullyQualifiedName(includeElement.getSource()).replaceAll("\\.", "/");
        _builder.append(_replaceAll);
        _builder.append(".fxml\"");
        StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)includeElement.getStaticProperties(), importManager, preview, skipController);
        _builder.append((Object)_elementStaticAttributes);
        StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)includeElement.getStaticCallProperties(), importManager, preview, skipController);
        _builder.append((Object)_elementStaticCallAttributes);
        _builder.append(" ");
        boolean _hasNestedProperties = this.hasNestedProperties(includeElement, preview);
        boolean bl2 = _not = !_hasNestedProperties;
        if (_not) {
            _builder.append("/");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(includeElement, preview);
        if (_hasNestedProperties_1) {
            _builder.append("\t");
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)includeElement.getStaticCallProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)includeElement.getStaticProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("</fx:include>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence referenceContent(ReferenceValueProperty referenceElement, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<fx:reference source=\"");
        String _refname = this.refname(referenceElement.getReference());
        _builder.append(_refname);
        _builder.append("\"");
        StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)referenceElement.getStaticProperties(), importManager, preview, skipController);
        _builder.append((Object)_elementStaticAttributes);
        StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)referenceElement.getStaticCallProperties(), importManager, preview, skipController);
        _builder.append((Object)_elementStaticCallAttributes);
        _builder.append(" ");
        boolean _hasNestedProperties = this.hasNestedProperties(referenceElement, preview);
        boolean bl = _not = !_hasNestedProperties;
        if (_not) {
            _builder.append("/");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(referenceElement, preview);
        if (_hasNestedProperties_1) {
            _builder.append("\t");
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)referenceElement.getStaticCallProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)referenceElement.getStaticProperties(), importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("</fx:reference>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence statCallPropContent(List<StaticCallValueProperty> properties, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = p -> this.previewFilter((StaticCallValueProperty)p, preview);
        Functions.Function1 _function_1 = p -> this.subelementFilter((StaticCallValueProperty)p);
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (StaticCallValueProperty prop : _filter) {
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equals(_stringValue, null);
                if (_notEquals) {
                    _builder.append("<");
                    String _shortName = this.shortName(prop.getType(), importManager);
                    _builder.append(_shortName);
                    _builder.append(".");
                    String _name = prop.getName();
                    _builder.append(_name);
                    _builder.append(">");
                    ValueProperty _value_2 = prop.getValue();
                    String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                    _builder.append(_stringValue_1);
                    _builder.append("</");
                    String _shortName_1 = this.shortName(prop.getType(), importManager);
                    _builder.append(_shortName_1);
                    _builder.append(".");
                    String _name_1 = prop.getName();
                    _builder.append(_name_1);
                    _builder.append(">");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("<");
                String _shortName_2 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_2);
                _builder.append(".");
                String _name_2 = prop.getName();
                _builder.append(_name_2);
                _builder.append(">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append(_simpleAttributeValue);
                _builder.append("</");
                String _shortName_3 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_3);
                _builder.append(".");
                String _name_3 = prop.getName();
                _builder.append(_name_3);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append("<");
                String _shortName_4 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_4);
                _builder.append(".");
                String _name_4 = prop.getName();
                _builder.append(_name_4);
                _builder.append("><");
                ValueProperty _value_5 = prop.getValue();
                String _shortName_5 = this.shortName(((ConstValueProperty)_value_5).getType(), importManager);
                _builder.append(_shortName_5);
                _builder.append(" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append(_field);
                _builder.append("\" /></");
                String _shortName_6 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_6);
                _builder.append(".");
                String _name_5 = prop.getName();
                _builder.append(_name_5);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_7 = prop.getValue();
            if (_value_7 instanceof ListValueProperty) {
                _builder.append("<");
                String _shortName_7 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_7);
                _builder.append(".");
                String _name_6 = prop.getName();
                _builder.append(_name_6);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_8 = prop.getValue();
                CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_propListContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_8 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_8);
                _builder.append(".");
                String _name_7 = prop.getName();
                _builder.append(_name_7);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_9 = prop.getValue();
            if (_value_9 instanceof MapValueProperty) {
                _builder.append("<");
                String _shortName_9 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_9);
                _builder.append(".");
                String _name_8 = prop.getName();
                _builder.append(_name_8);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_10 = prop.getValue();
                CharSequence _propContents = this.propContents((List<Property>)((MapValueProperty)_value_10).getProperties(), importManager, preview, true, skipController, skipIncludes);
                _builder.append((Object)_propContents, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_10 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_10);
                _builder.append(".");
                String _name_9 = prop.getName();
                _builder.append(_name_9);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_11 = prop.getValue();
            if (_value_11 instanceof Element) {
                _builder.append("<");
                String _shortName_11 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_11);
                _builder.append(".");
                String _name_10 = prop.getName();
                _builder.append(_name_10);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_12 = prop.getValue();
                CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_12 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_12);
                _builder.append(".");
                String _name_11 = prop.getName();
                _builder.append(_name_11);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_13 = prop.getValue();
            if (_value_13 instanceof ReferenceValueProperty) {
                _builder.append("<");
                String _shortName_13 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_13);
                _builder.append(".");
                String _name_12 = prop.getName();
                _builder.append(_name_12);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_14 = prop.getValue();
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_14 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_14);
                _builder.append(".");
                String _name_13 = prop.getName();
                _builder.append(_name_13);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_15 = prop.getValue();
            if (_value_15 instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                _builder.append("<");
                String _shortName_15 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_15);
                _builder.append(".");
                String _name_14 = prop.getName();
                _builder.append(_name_14);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_16 = prop.getValue();
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_16 = this.shortName(prop.getType(), importManager);
                _builder.append(_shortName_16);
                _builder.append(".");
                String _name_15 = prop.getName();
                _builder.append(_name_15);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_17 = prop.getValue();
            if (!(_value_17 instanceof CopyValueProperty)) continue;
            _builder.append("<");
            String _shortName_17 = this.shortName(prop.getType(), importManager);
            _builder.append(_shortName_17);
            _builder.append(".");
            String _name_16 = prop.getName();
            _builder.append(_name_16);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<fx:copy source=\"");
            ValueProperty _value_18 = prop.getValue();
            String _name_17 = ((CopyValueProperty)_value_18).getReference().getName();
            _builder.append(_name_17, "\t");
            _builder.append("\" />");
            _builder.newLineIfNotEmpty();
            _builder.append("</");
            String _shortName_18 = this.shortName(prop.getType(), importManager);
            _builder.append(_shortName_18);
            _builder.append(".");
            String _name_18 = prop.getName();
            _builder.append(_name_18);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence statPropContent(List<StaticValueProperty> properties, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = p -> this.previewFilter((StaticValueProperty)p, preview);
        Functions.Function1 _function_1 = p -> this.subelementFilter((StaticValueProperty)p);
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (StaticValueProperty prop : _filter) {
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equals(_stringValue, null);
                if (_notEquals) {
                    _builder.append("<");
                    String _shortName = this.shortName(this.type(prop), importManager);
                    _builder.append(_shortName);
                    _builder.append(".");
                    String _name = prop.getName();
                    _builder.append(_name);
                    _builder.append(">");
                    ValueProperty _value_2 = prop.getValue();
                    String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                    _builder.append(_stringValue_1);
                    _builder.append("</");
                    String _shortName_1 = this.shortName(this.type(prop), importManager);
                    _builder.append(_shortName_1);
                    _builder.append(".");
                    String _name_1 = prop.getName();
                    _builder.append(_name_1);
                    _builder.append(">");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("<");
                String _shortName_2 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_2);
                _builder.append(".");
                String _name_2 = prop.getName();
                _builder.append(_name_2);
                _builder.append(">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append(_simpleAttributeValue);
                _builder.append("</");
                String _shortName_3 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_3);
                _builder.append(".");
                String _name_3 = prop.getName();
                _builder.append(_name_3);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append("<");
                String _shortName_4 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_4);
                _builder.append(".");
                String _name_4 = prop.getName();
                _builder.append(_name_4);
                _builder.append("><");
                ValueProperty _value_5 = prop.getValue();
                String _shortName_5 = this.shortName(((ConstValueProperty)_value_5).getType(), importManager);
                _builder.append(_shortName_5);
                _builder.append(" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append(_field);
                _builder.append("\" /></");
                String _shortName_6 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_6);
                _builder.append(".");
                String _name_5 = prop.getName();
                _builder.append(_name_5);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_7 = prop.getValue();
            if (_value_7 instanceof ListValueProperty) {
                _builder.append("<");
                String _shortName_7 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_7);
                _builder.append(".");
                String _name_6 = prop.getName();
                _builder.append(_name_6);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_8 = prop.getValue();
                CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_propListContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_8 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_8);
                _builder.append(".");
                String _name_7 = prop.getName();
                _builder.append(_name_7);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_9 = prop.getValue();
            if (_value_9 instanceof MapValueProperty) {
                _builder.append("<");
                String _shortName_9 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_9);
                _builder.append(".");
                String _name_8 = prop.getName();
                _builder.append(_name_8);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_10 = prop.getValue();
                CharSequence _propContents = this.propContents((List<Property>)((MapValueProperty)_value_10).getProperties(), importManager, preview, true, skipController, skipIncludes);
                _builder.append((Object)_propContents, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_10 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_10);
                _builder.append(".");
                String _name_9 = prop.getName();
                _builder.append(_name_9);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_11 = prop.getValue();
            if (_value_11 instanceof Element) {
                _builder.append("<");
                String _shortName_11 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_11);
                _builder.append(".");
                String _name_10 = prop.getName();
                _builder.append(_name_10);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_12 = prop.getValue();
                CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_12 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_12);
                _builder.append(".");
                String _name_11 = prop.getName();
                _builder.append(_name_11);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_13 = prop.getValue();
            if (_value_13 instanceof ReferenceValueProperty) {
                _builder.append("<");
                String _shortName_13 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_13);
                _builder.append(".");
                String _name_12 = prop.getName();
                _builder.append(_name_12);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_14 = prop.getValue();
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_14 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_14);
                _builder.append(".");
                String _name_13 = prop.getName();
                _builder.append(_name_13);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_15 = prop.getValue();
            if (_value_15 instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                _builder.append("<");
                String _shortName_15 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_15);
                _builder.append(".");
                String _name_14 = prop.getName();
                _builder.append(_name_14);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                ValueProperty _value_16 = prop.getValue();
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("</");
                String _shortName_16 = this.shortName(this.type(prop), importManager);
                _builder.append(_shortName_16);
                _builder.append(".");
                String _name_15 = prop.getName();
                _builder.append(_name_15);
                _builder.append(">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_17 = prop.getValue();
            if (!(_value_17 instanceof CopyValueProperty)) continue;
            _builder.append("<");
            String _shortName_17 = this.shortName(this.type(prop), importManager);
            _builder.append(_shortName_17);
            _builder.append(".");
            String _name_16 = prop.getName();
            _builder.append(_name_16);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<fx:copy source=\"");
            ValueProperty _value_18 = prop.getValue();
            String _name_17 = ((CopyValueProperty)_value_18).getReference().getName();
            _builder.append(_name_17, "\t");
            _builder.append("\" />");
            _builder.newLineIfNotEmpty();
            _builder.append("</");
            String _shortName_18 = this.shortName(this.type(prop), importManager);
            _builder.append(_shortName_18);
            _builder.append(".");
            String _name_18 = prop.getName();
            _builder.append(_name_18);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public JvmTypeReference type(StaticValueProperty prop) {
        EObject el = prop.eContainer();
        while (!Objects.equals(el.eContainer(), null)) {
            EObject _eContainer = el.eContainer();
            if (_eContainer instanceof Element) {
                EObject _eContainer_1 = el.eContainer();
                Element e = (Element)_eContainer_1;
                return e.getType();
            }
            el = el.eContainer();
        }
        return null;
    }

    public String refname(ReferenceType e) {
        if (e instanceof Element) {
            return ((Element)e).getName();
        }
        return ((IncludeValueProperty)e).getName();
    }

    public CharSequence propListContent(ListValueProperty listProp, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ListValueElement> _value = listProp.getValue();
        for (ListValueElement e : _value) {
            if (e instanceof Element) {
                CharSequence _elementContent = this.elementContent((Element)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent);
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (e instanceof ReferenceValueProperty) {
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent);
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (e instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent);
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(e instanceof SimpleValueProperty)) continue;
            String _objectLiteral = this.objectLiteral((SimpleValueProperty)e);
            _builder.append(_objectLiteral);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String fullyQualifiedName(ComponentDefinition cp) {
        boolean _notEquals;
        EObject _get = (EObject)cp.eResource().getContents().get(0);
        Model m = (Model)_get;
        PackageDeclaration _package = m.getPackage();
        boolean bl = _notEquals = !Objects.equals(_package, null);
        if (_notEquals) {
            String _name = m.getPackage().getName();
            String _plus = _name + ".";
            String _name_1 = cp.getName();
            return _plus + _name_1;
        }
        return cp.getName();
    }

    public String fxElementAttributes(Element element, ImportManager importManager, boolean skipController) {
        SimpleValueProperty _value;
        boolean _notEquals_1;
        boolean _notEquals;
        StringBuilder builder = new StringBuilder();
        String _name = element.getName();
        boolean bl = _notEquals = !Objects.equals(_name, null);
        if (_notEquals) {
            String _name_1 = element.getName();
            String _plus = " fx:id=\"" + _name_1;
            String _plus_1 = _plus + "\"";
            builder.append(_plus_1);
        }
        boolean bl2 = _notEquals_1 = !Objects.equals(_value = element.getValue(), null);
        if (_notEquals_1) {
            String _simpleAttributeValue = this.simpleAttributeValue(element.getValue());
            String _plus_2 = " fx:value=\"" + _simpleAttributeValue;
            String _plus_3 = _plus_2 + "\"";
            builder.append(_plus_3);
        } else {
            boolean _notEquals_2;
            String _factory = element.getFactory();
            boolean bl3 = _notEquals_2 = !Objects.equals(_factory, null);
            if (_notEquals_2) {
                String _factory_1 = element.getFactory();
                String _plus_4 = " fx:factory=\"" + _factory_1;
                String _plus_5 = _plus_4 + "\"";
                builder.append(_plus_5);
            }
        }
        return builder.toString();
    }

    public StringBuilder elementAttributes(List<Property> properties, boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1 _function = p -> this.previewFilter((Property)p, preview);
        Functions.Function1 _function_1 = p -> this.elementAttributeFilter((Property)p);
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (Property p2 : _filter) {
            ValueProperty _value = p2.getValue();
            if (_value instanceof SimpleValueProperty) {
                String _name = p2.getName();
                String _plus = " " + _name;
                String _plus_1 = _plus + "=\"";
                ValueProperty _value_1 = p2.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_2 = _plus_1 + _simpleAttributeValue;
                String _plus_3 = _plus_2 + "\"";
                builder.append(_plus_3);
                continue;
            }
            ValueProperty _value_2 = p2.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                String _name_1 = p2.getName();
                String _plus_4 = " " + _name_1;
                String _plus_5 = _plus_4 + "=\"$";
                ValueProperty _value_3 = p2.getValue();
                String _refname = this.refname(((ReferenceValueProperty)_value_3).getReference());
                String _plus_6 = _plus_5 + _refname;
                String _plus_7 = _plus_6 + "\"";
                builder.append(_plus_7);
                continue;
            }
            ValueProperty _value_4 = p2.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                String _name_2 = p2.getName();
                String _plus_8 = " " + _name_2;
                String _plus_9 = _plus_8 + "=\"#";
                ValueProperty _value_5 = p2.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_10 = _plus_9 + _methodname;
                String _plus_11 = _plus_10 + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_6 = p2.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                String _name_3 = p2.getName();
                String _plus_12 = " " + _name_3;
                String _plus_13 = _plus_12 + "=\"";
                ValueProperty _value_7 = p2.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_14 = _plus_13 + _functionname;
                String _plus_15 = _plus_14 + "\"";
                builder.append(_plus_15);
                continue;
            }
            ValueProperty _value_8 = p2.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                String _name_4 = p2.getName();
                String _plus_16 = " " + _name_4;
                String _plus_17 = _plus_16 + "=\"";
                ValueProperty _value_9 = p2.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p2.getValue();
                int _length = ((ScriptValueExpression)_value_10).getSourcecode().length();
                int _minus = _length - 2;
                String _trim = _sourcecode.substring(2, _minus).trim();
                String _plus_18 = _plus_17 + _trim;
                String _plus_19 = _plus_18 + ";\"";
                builder.append(_plus_19);
                continue;
            }
            ValueProperty _value_11 = p2.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                String _name_5 = p2.getName();
                String _plus_20 = " " + _name_5;
                String _plus_21 = _plus_20 + "=\"$";
                ValueProperty _value_12 = p2.getValue();
                String _reference = ((ScriptValueReference)_value_12).getReference();
                String _plus_22 = _plus_21 + _reference;
                String _plus_23 = _plus_22 + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_13 = p2.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                String _name_6 = p2.getName();
                String _plus_24 = " " + _name_6;
                String _plus_25 = _plus_24 + "=\"@";
                ValueProperty _value_14 = p2.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_26 = _plus_25 + _value_15;
                String _plus_27 = _plus_26 + "\"";
                builder.append(_plus_27);
                continue;
            }
            ValueProperty _value_16 = p2.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                String _name_7 = p2.getName();
                String _plus_28 = " " + _name_7;
                String _plus_29 = _plus_28 + "=\"%";
                ValueProperty _value_17 = p2.getValue();
                String _value_18 = ((ResourceValueProperty)_value_17).getValue().getValue();
                String _plus_30 = _plus_29 + _value_18;
                String _plus_31 = _plus_30 + "\"";
                builder.append(_plus_31);
                continue;
            }
            ValueProperty _value_19 = p2.getValue();
            if (!(_value_19 instanceof BindValueProperty)) continue;
            String _name_8 = p2.getName();
            String _plus_32 = " " + _name_8;
            String _plus_33 = _plus_32 + "=\"${";
            ValueProperty _value_20 = p2.getValue();
            String _name_9 = ((BindValueProperty)_value_20).getElementReference().getName();
            String _plus_34 = _plus_33 + _name_9;
            String _plus_35 = _plus_34 + ".";
            ValueProperty _value_21 = p2.getValue();
            String _attribute = ((BindValueProperty)_value_21).getAttribute();
            String _plus_36 = _plus_35 + _attribute;
            String _plus_37 = _plus_36 + "}\"";
            builder.append(_plus_37);
        }
        return builder;
    }

    public StringBuilder elementStaticCallAttributes(List<StaticCallValueProperty> properties, ImportManager importManager, boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1 _function = p -> this.previewFilter((StaticCallValueProperty)p, preview);
        Functions.Function1 _function_1 = p -> this.elementAttributeFilter((StaticCallValueProperty)p);
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (StaticCallValueProperty p2 : _filter) {
            ValueProperty _value = p2.getValue();
            if (_value instanceof SimpleValueProperty) {
                String _shortName = this.shortName(p2.getType(), importManager);
                String _plus = " " + _shortName;
                String _plus_1 = _plus + ".";
                String _name = p2.getName();
                String _plus_2 = _plus_1 + _name;
                String _plus_3 = _plus_2 + "=\"";
                ValueProperty _value_1 = p2.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_4 = _plus_3 + _simpleAttributeValue;
                String _plus_5 = _plus_4 + "\"";
                builder.append(_plus_5);
                continue;
            }
            ValueProperty _value_2 = p2.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                String _shortName_1 = this.shortName(p2.getType(), importManager);
                String _plus_6 = " " + _shortName_1;
                String _plus_7 = _plus_6 + ".";
                String _name_1 = p2.getName();
                String _plus_8 = _plus_7 + _name_1;
                String _plus_9 = _plus_8 + "=\"$";
                ValueProperty _value_3 = p2.getValue();
                String _refname = this.refname(((ReferenceValueProperty)_value_3).getReference());
                String _plus_10 = _plus_9 + _refname;
                String _plus_11 = _plus_10 + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_4 = p2.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                String _shortName_2 = this.shortName(p2.getType(), importManager);
                String _plus_12 = " " + _shortName_2;
                String _plus_13 = _plus_12 + ".";
                String _name_2 = p2.getName();
                String _plus_14 = _plus_13 + _name_2;
                String _plus_15 = _plus_14 + "=\"#";
                ValueProperty _value_5 = p2.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_16 = _plus_15 + _methodname;
                String _plus_17 = _plus_16 + "\"";
                builder.append(_plus_17);
                continue;
            }
            ValueProperty _value_6 = p2.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                String _shortName_3 = this.shortName(p2.getType(), importManager);
                String _plus_18 = " " + _shortName_3;
                String _plus_19 = _plus_18 + ".";
                String _name_3 = p2.getName();
                String _plus_20 = _plus_19 + _name_3;
                String _plus_21 = _plus_20 + "=\"";
                ValueProperty _value_7 = p2.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_22 = _plus_21 + _functionname;
                String _plus_23 = _plus_22 + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_8 = p2.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                String _shortName_4 = this.shortName(p2.getType(), importManager);
                String _plus_24 = " " + _shortName_4;
                String _plus_25 = _plus_24 + ".";
                String _name_4 = p2.getName();
                String _plus_26 = _plus_25 + _name_4;
                String _plus_27 = _plus_26 + "=\"";
                ValueProperty _value_9 = p2.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p2.getValue();
                int _length = ((ScriptValueExpression)_value_10).getSourcecode().length();
                int _minus = _length - 2;
                String _trim = _sourcecode.substring(2, _minus).trim();
                String _plus_28 = _plus_27 + _trim;
                String _plus_29 = _plus_28 + ";\"";
                builder.append(_plus_29);
                continue;
            }
            ValueProperty _value_11 = p2.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                String _shortName_5 = this.shortName(p2.getType(), importManager);
                String _plus_30 = " " + _shortName_5;
                String _plus_31 = _plus_30 + ".";
                String _name_5 = p2.getName();
                String _plus_32 = _plus_31 + _name_5;
                String _plus_33 = _plus_32 + "=\"$";
                ValueProperty _value_12 = p2.getValue();
                String _reference = ((ScriptValueReference)_value_12).getReference();
                String _plus_34 = _plus_33 + _reference;
                String _plus_35 = _plus_34 + "\"";
                builder.append(_plus_35);
                continue;
            }
            ValueProperty _value_13 = p2.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                String _shortName_6 = this.shortName(p2.getType(), importManager);
                String _plus_36 = " " + _shortName_6;
                String _plus_37 = _plus_36 + ".";
                String _name_6 = p2.getName();
                String _plus_38 = _plus_37 + _name_6;
                String _plus_39 = _plus_38 + "=\"@";
                ValueProperty _value_14 = p2.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_40 = _plus_39 + _value_15;
                String _plus_41 = _plus_40 + "\"";
                builder.append(_plus_41);
                continue;
            }
            ValueProperty _value_16 = p2.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                String _shortName_7 = this.shortName(p2.getType(), importManager);
                String _plus_42 = " " + _shortName_7;
                String _plus_43 = _plus_42 + ".";
                String _name_7 = p2.getName();
                String _plus_44 = _plus_43 + _name_7;
                String _plus_45 = _plus_44 + "=\"%";
                ValueProperty _value_17 = p2.getValue();
                String _value_18 = ((ResourceValueProperty)_value_17).getValue().getValue();
                String _plus_46 = _plus_45 + _value_18;
                String _plus_47 = _plus_46 + "\"";
                builder.append(_plus_47);
                continue;
            }
            ValueProperty _value_19 = p2.getValue();
            if (!(_value_19 instanceof BindValueProperty)) continue;
            String _shortName_8 = this.shortName(p2.getType(), importManager);
            String _plus_48 = " " + _shortName_8;
            String _plus_49 = _plus_48 + ".";
            String _name_8 = p2.getName();
            String _plus_50 = _plus_49 + _name_8;
            String _plus_51 = _plus_50 + "=\"${";
            ValueProperty _value_20 = p2.getValue();
            String _name_9 = ((BindValueProperty)_value_20).getElementReference().getName();
            String _plus_52 = _plus_51 + _name_9;
            String _plus_53 = _plus_52 + ".";
            ValueProperty _value_21 = p2.getValue();
            String _attribute = ((BindValueProperty)_value_21).getAttribute();
            String _plus_54 = _plus_53 + _attribute;
            String _plus_55 = _plus_54 + "}\"";
            builder.append(_plus_55);
        }
        return builder;
    }

    public StringBuilder elementStaticAttributes(List<StaticValueProperty> properties, ImportManager importManager, boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1 _function = p -> this.previewFilter((StaticValueProperty)p, preview);
        Functions.Function1 _function_1 = p -> this.elementAttributeFilter((StaticValueProperty)p);
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(properties, (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (StaticValueProperty p2 : _filter) {
            ValueProperty _value = p2.getValue();
            if (_value instanceof SimpleValueProperty) {
                String _shortName = this.shortName(this.type(p2), importManager);
                String _plus = " " + _shortName;
                String _plus_1 = _plus + ".";
                String _name = p2.getName();
                String _plus_2 = _plus_1 + _name;
                String _plus_3 = _plus_2 + "=\"";
                ValueProperty _value_1 = p2.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_4 = _plus_3 + _simpleAttributeValue;
                String _plus_5 = _plus_4 + "\"";
                builder.append(_plus_5);
                continue;
            }
            ValueProperty _value_2 = p2.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                String _shortName_1 = this.shortName(this.type(p2), importManager);
                String _plus_6 = " " + _shortName_1;
                String _plus_7 = _plus_6 + ".";
                String _name_1 = p2.getName();
                String _plus_8 = _plus_7 + _name_1;
                String _plus_9 = _plus_8 + "=\"$";
                ValueProperty _value_3 = p2.getValue();
                String _refname = this.refname(((ReferenceValueProperty)_value_3).getReference());
                String _plus_10 = _plus_9 + _refname;
                String _plus_11 = _plus_10 + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_4 = p2.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                String _shortName_2 = this.shortName(this.type(p2), importManager);
                String _plus_12 = " " + _shortName_2;
                String _plus_13 = _plus_12 + ".";
                String _name_2 = p2.getName();
                String _plus_14 = _plus_13 + _name_2;
                String _plus_15 = _plus_14 + "=\"#";
                ValueProperty _value_5 = p2.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_16 = _plus_15 + _methodname;
                String _plus_17 = _plus_16 + "\"";
                builder.append(_plus_17);
                continue;
            }
            ValueProperty _value_6 = p2.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                String _shortName_3 = this.shortName(this.type(p2), importManager);
                String _plus_18 = " " + _shortName_3;
                String _plus_19 = _plus_18 + ".";
                String _name_3 = p2.getName();
                String _plus_20 = _plus_19 + _name_3;
                String _plus_21 = _plus_20 + "=\"";
                ValueProperty _value_7 = p2.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_22 = _plus_21 + _functionname;
                String _plus_23 = _plus_22 + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_8 = p2.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                String _shortName_4 = this.shortName(this.type(p2), importManager);
                String _plus_24 = " " + _shortName_4;
                String _plus_25 = _plus_24 + ".";
                String _name_4 = p2.getName();
                String _plus_26 = _plus_25 + _name_4;
                String _plus_27 = _plus_26 + "=\"";
                ValueProperty _value_9 = p2.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p2.getValue();
                int _length = ((ScriptValueExpression)_value_10).getSourcecode().length();
                int _minus = _length - 2;
                String _trim = _sourcecode.substring(2, _minus).trim();
                String _plus_28 = _plus_27 + _trim;
                String _plus_29 = _plus_28 + ";\"";
                builder.append(_plus_29);
                continue;
            }
            ValueProperty _value_11 = p2.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                String _shortName_5 = this.shortName(this.type(p2), importManager);
                String _plus_30 = " " + _shortName_5;
                String _plus_31 = _plus_30 + ".";
                String _name_5 = p2.getName();
                String _plus_32 = _plus_31 + _name_5;
                String _plus_33 = _plus_32 + "=\"$";
                ValueProperty _value_12 = p2.getValue();
                String _reference = ((ScriptValueReference)_value_12).getReference();
                String _plus_34 = _plus_33 + _reference;
                String _plus_35 = _plus_34 + "\"";
                builder.append(_plus_35);
                continue;
            }
            ValueProperty _value_13 = p2.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                String _shortName_6 = this.shortName(this.type(p2), importManager);
                String _plus_36 = " " + _shortName_6;
                String _plus_37 = _plus_36 + ".";
                String _name_6 = p2.getName();
                String _plus_38 = _plus_37 + _name_6;
                String _plus_39 = _plus_38 + "=\"@";
                ValueProperty _value_14 = p2.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_40 = _plus_39 + _value_15;
                String _plus_41 = _plus_40 + "\"";
                builder.append(_plus_41);
                continue;
            }
            ValueProperty _value_16 = p2.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                String _shortName_7 = this.shortName(this.type(p2), importManager);
                String _plus_42 = " " + _shortName_7;
                String _plus_43 = _plus_42 + ".";
                String _name_7 = p2.getName();
                String _plus_44 = _plus_43 + _name_7;
                String _plus_45 = _plus_44 + "=\"%";
                ValueProperty _value_17 = p2.getValue();
                String _value_18 = ((ResourceValueProperty)_value_17).getValue().getValue();
                String _plus_46 = _plus_45 + _value_18;
                String _plus_47 = _plus_46 + "\"";
                builder.append(_plus_47);
                continue;
            }
            ValueProperty _value_19 = p2.getValue();
            if (!(_value_19 instanceof BindValueProperty)) continue;
            String _shortName_8 = this.shortName(this.type(p2), importManager);
            String _plus_48 = " " + _shortName_8;
            String _plus_49 = _plus_48 + ".";
            String _name_8 = p2.getName();
            String _plus_50 = _plus_49 + _name_8;
            String _plus_51 = _plus_50 + "=\"${";
            ValueProperty _value_20 = p2.getValue();
            String _name_9 = ((BindValueProperty)_value_20).getElementReference().getName();
            String _plus_52 = _plus_51 + _name_9;
            String _plus_53 = _plus_52 + ".";
            ValueProperty _value_21 = p2.getValue();
            String _attribute = ((BindValueProperty)_value_21).getAttribute();
            String _plus_54 = _plus_53 + _attribute;
            String _plus_55 = _plus_54 + "}\"";
            builder.append(_plus_55);
        }
        return builder;
    }

    public boolean subelementFilter(Property property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(Property property) {
        return this.elementAttributeFilter(property.getValue());
    }

    public boolean subelementFilter(StaticCallValueProperty property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(StaticCallValueProperty property) {
        return this.elementAttributeFilter(property.getValue());
    }

    public boolean subelementFilter(StaticValueProperty property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(StaticValueProperty property) {
        return this.elementAttributeFilter(property.getValue());
    }

    public boolean elementAttributeFilter(ValueProperty value) {
        if (value instanceof SimpleValueProperty) {
            return true;
        }
        if (value instanceof ReferenceValueProperty) {
            ReferenceValueProperty r = (ReferenceValueProperty)value;
            return r.getStaticCallProperties().isEmpty() && r.getStaticProperties().isEmpty();
        }
        if (value instanceof ControllerHandledValueProperty) {
            return true;
        }
        if (value instanceof ScriptHandlerHandledValueProperty) {
            return true;
        }
        if (value instanceof ScriptValueReference) {
            return true;
        }
        if (value instanceof ScriptValueExpression) {
            return true;
        }
        if (value instanceof LocationValueProperty) {
            return true;
        }
        if (value instanceof ResourceValueProperty) {
            return true;
        }
        return value instanceof BindValueProperty;
    }

    public String simpleAttributeValue(SimpleValueProperty value) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equals(_stringValue, null);
        if (_notEquals) {
            return value.getStringValue();
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equals(_booleanValue, null);
        if (_notEquals_1) {
            return value.getBooleanValue();
        }
        if (!Objects.equals(value.getNumber(), null) && FXGraphGenerator.isIntNumber(value.getNumber())) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number = value.getNumber();
                return "-" + _number;
            }
            return value.getNumber();
        }
        boolean _isNegative_1 = value.isNegative();
        if (_isNegative_1) {
            String _number_1 = value.getNumber();
            return "-" + _number_1;
        }
        return value.getNumber();
    }

    public boolean previewFilter(Property property, boolean preview) {
        boolean _equals_1;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(property.getModifier())) : (_equals_1 = "runtime-only".equals(property.getModifier())));
    }

    public boolean previewFilter(StaticCallValueProperty property, boolean preview) {
        boolean _equals_1;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(property.getModifier())) : (_equals_1 = "runtime-only".equals(property.getModifier())));
    }

    public boolean previewFilter(StaticValueProperty property, boolean preview) {
        boolean _equals_1;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(property.getModifier())) : (_equals_1 = "runtime-only".equals(property.getModifier())));
    }

    public boolean hasAttributeProperties(Element element, boolean preview) {
        return element.getProperties().size() > 0 && !IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getProperties(), p -> this.previewFilter((Property)p, preview)), p -> this.elementAttributeFilter((Property)p))) || element.getStaticCallProperties().size() > 0 && !IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticCallProperties(), p -> this.previewFilter((StaticCallValueProperty)p, preview)), p -> this.elementAttributeFilter((StaticCallValueProperty)p))) || element.getStaticProperties().size() > 0 && !IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticProperties(), p -> this.previewFilter((StaticValueProperty)p, preview)), p -> this.elementAttributeFilter((StaticValueProperty)p)));
    }

    public boolean hasNestedProperties(Element element, boolean preview) {
        int _size_4;
        boolean _greaterThan_4;
        int _size_3;
        boolean _greaterThan_3;
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _greaterThan;
        int _size = element.getValues().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        int _size_1 = element.getDefaultChildren().size();
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            return true;
        }
        int _size_2 = element.getStaticCallProperties().size();
        boolean bl3 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            boolean _not;
            Functions.Function1 _function = p -> this.previewFilter((StaticCallValueProperty)p, preview);
            Functions.Function1 _function_1 = p -> this.subelementFilter((StaticCallValueProperty)p);
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticCallProperties(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            boolean bl4 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl5 = _greaterThan_3 = (_size_3 = element.getStaticProperties().size()) > 0;
        if (_greaterThan_3) {
            boolean _not_1;
            Functions.Function1 _function_2 = p -> this.previewFilter((StaticValueProperty)p, preview);
            Functions.Function1 _function_3 = p -> this.subelementFilter((StaticValueProperty)p);
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticProperties(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
            boolean bl6 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        boolean bl7 = _greaterThan_4 = (_size_4 = element.getProperties().size()) > 0;
        if (_greaterThan_4) {
            boolean _not_2;
            Functions.Function1 _function_4 = p -> this.previewFilter((Property)p, preview);
            Functions.Function1 _function_5 = p -> this.subelementFilter((Property)p);
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getProperties(), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
            boolean bl8 = _not_2 = !_isNullOrEmpty_2;
            if (_not_2) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAttributeProperties(IncludeValueProperty element, boolean preview) {
        return element.getStaticCallProperties().size() > 0 && !IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticCallProperties(), p -> this.previewFilter((StaticCallValueProperty)p, preview)), p -> this.elementAttributeFilter((StaticCallValueProperty)p))) || element.getStaticProperties().size() > 0 && !IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticProperties(), p -> this.previewFilter((StaticValueProperty)p, preview)), p -> this.elementAttributeFilter((StaticValueProperty)p)));
    }

    public boolean hasNestedProperties(IncludeValueProperty element, boolean preview) {
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        int _size = element.getStaticCallProperties().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _not;
            Functions.Function1 _function = p -> this.previewFilter((StaticCallValueProperty)p, preview);
            Functions.Function1 _function_1 = p -> this.subelementFilter((StaticCallValueProperty)p);
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticCallProperties(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl3 = _greaterThan_1 = (_size_1 = element.getStaticProperties().size()) > 0;
        if (_greaterThan_1) {
            boolean _not_1;
            Functions.Function1 _function_2 = p -> this.previewFilter((StaticValueProperty)p, preview);
            Functions.Function1 _function_3 = p -> this.subelementFilter((StaticValueProperty)p);
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticProperties(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
            boolean bl4 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        return false;
    }

    public boolean hasNestedProperties(ReferenceValueProperty element, boolean preview) {
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        int _size = element.getStaticCallProperties().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _not;
            Functions.Function1 _function = p -> this.previewFilter((StaticCallValueProperty)p, preview);
            Functions.Function1 _function_1 = p -> this.subelementFilter((StaticCallValueProperty)p);
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticCallProperties(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl3 = _greaterThan_1 = (_size_1 = element.getStaticProperties().size()) > 0;
        if (_greaterThan_1) {
            boolean _not_1;
            Functions.Function1 _function_2 = p -> this.previewFilter((StaticValueProperty)p, preview);
            Functions.Function1 _function_3 = p -> this.subelementFilter((StaticValueProperty)p);
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(element.getStaticProperties(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
            boolean bl4 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        return false;
    }

    public String shortName(JvmTypeReference r, ImportManager importManager) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder();
        importManager.appendType(r.getType(), builder);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    public static boolean isIntNumber(String number) {
        return number.matches("\\d[\\d|_]*");
    }
}

