/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.preview;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.embed.swt.FXCanvas;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Transform;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.ide.ui.preview.LivePreviewSynchronizer;
import org.eclipse.fx.ide.ui.preview.ReflectiveInvoke;
import org.eclipse.fx.ide.ui.preview.bundle.Activator;
import org.eclipse.fx.ide.ui.preview.text.AnnotationAccess;
import org.eclipse.fx.ide.ui.preview.text.ColorManager;
import org.eclipse.fx.ide.ui.preview.text.XMLConfiguration;
import org.eclipse.fx.ide.ui.preview.text.XMLPartitionScanner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class LivePreviewPart
extends ViewPart {
    public static final String PREF_LOAD_CONTROLLER = "PREF_LOAD_CONTROLLER";
    @Inject
    private LivePreviewSynchronizer synchronizer;
    private Node rootPane_new;
    private Text logStatement;
    private CTabFolder folder;
    private static final String IMAGE_OK = LivePreviewPart.class.getName() + ".IMAGE_OK";
    private static final String IMAGE_WARNING = LivePreviewPart.class.getName() + ".IMAGE_WARNING";
    private static final String IMAGE_ERROR = LivePreviewPart.class.getName() + ".IMAGE_ERROR";
    private static final String IMAGE_PREVIEW = LivePreviewPart.class.getName() + ".IMAGE_PREVIEW";
    private static final String IMAGE_TAB_ERROR = LivePreviewPart.class.getName() + ".IMAGE_TAB_ERROR";
    private static final String IMAGE_TAB_WARNING = LivePreviewPart.class.getName() + ".IMAGE_TAB_WARNING";
    private static final String IMAGE_TAB_NORMAL = LivePreviewPart.class.getName() + ".IMAGE_TAB_NORMAL";
    private static final String IMAGE_STATUS_ERROR = LivePreviewPart.class.getName() + ".IMAGE_STATUS_ERROR";
    private static final String IMAGE_STATUS_WARNING = LivePreviewPart.class.getName() + ".IMAGE_STATUS_WARNING";
    private static final String IMAGE_STATUS_OK = LivePreviewPart.class.getName() + ".IMAGE_STATUS_OK";
    private static final String IMAGE_STATUS_NOPREVIEW = LivePreviewPart.class.getName() + ".IMAGE_STATUS_NOPREVIEW";
    private static final String IMAGE_LOAD_CONTROLLER = LivePreviewPart.class.getName() + ".IMAGE_LOAD_CONTROLLER";
    private static final String IMAGE_REFRESH = LivePreviewPart.class.getName() + ".IMAGE_REFRESH";
    private static final String IMAGE_FXML_CONTENT = LivePreviewPart.class.getName() + ".IMAGE_FXML_CONTENT";
    private static final String NO_PREVIEW_TEXT = "No preview available";
    protected static final int VERTICAL_RULER_WIDTH = 20;
    private IEclipsePreferences preference = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ide.ui.preview");
    private CTabItem logItem;
    private Label statusLabelIcon;
    private Label statusLabelText;
    private FXCanvas swtFXContainer;
    private IPartListener listener;
    private Spinner scale;
    private Map<IFile, Integer> scaleMap = new HashMap<IFile, Integer>();
    private IFile currentFile;
    private IDocument document;
    private ContentData currentData;
    private Scene currentScene;
    private SCREEN_SIZE currentSize = SCREEN_SIZE.DEFAULT;
    private Action screenSize;
    private boolean currentHorizontal;
    private Scene defaultScene;

    static {
        JFaceResources.getImageRegistry().put(IMAGE_OK, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/security-high.png"));
        JFaceResources.getImageRegistry().put(IMAGE_WARNING, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/security-medium.png"));
        JFaceResources.getImageRegistry().put(IMAGE_ERROR, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/security-low.png"));
        JFaceResources.getImageRegistry().put(IMAGE_PREVIEW, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/view-preview.png"));
        JFaceResources.getImageRegistry().put(IMAGE_TAB_NORMAL, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/view-preview.png"));
        JFaceResources.getImageRegistry().put(IMAGE_TAB_ERROR, (ImageDescriptor)new DecorationOverlayIcon(JFaceResources.getImage((String)IMAGE_TAB_NORMAL), Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/ovr/error_co.gif"), 2));
        JFaceResources.getImageRegistry().put(IMAGE_TAB_WARNING, (ImageDescriptor)new DecorationOverlayIcon(JFaceResources.getImage((String)IMAGE_TAB_NORMAL), Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/ovr/warning_co.gif"), 2));
        JFaceResources.getImageRegistry().put(IMAGE_STATUS_ERROR, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/dialog-error.png"));
        JFaceResources.getImageRegistry().put(IMAGE_STATUS_WARNING, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/dialog-warning.png"));
        JFaceResources.getImageRegistry().put(IMAGE_STATUS_OK, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/dialog-ok-apply.png"));
        JFaceResources.getImageRegistry().put(IMAGE_STATUS_NOPREVIEW, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/dialog-information.png"));
        JFaceResources.getImageRegistry().put(IMAGE_LOAD_CONTROLLER, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/system-switch-user.png"));
        JFaceResources.getImageRegistry().put(IMAGE_REFRESH, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/edit-clear.png"));
        JFaceResources.getImageRegistry().put(IMAGE_FXML_CONTENT, Activator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.ui.preview", (String)"/icons/16_16/page_white_code_red.png"));
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.listener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part == LivePreviewPart.this && LivePreviewPart.this.swtFXContainer != null) {
                    LivePreviewPart.this.swtFXContainer.setEnabled(false);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == LivePreviewPart.this && LivePreviewPart.this.swtFXContainer != null) {
                    LivePreviewPart.this.swtFXContainer.setEnabled(true);
                }
            }
        };
        site.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.synchronizer);
        site.getWorkbenchWindow().getPartService().addPartListener(this.listener);
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.folder = new CTabFolder(container, 3072);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.document = new Document();
        CTabItem item = new CTabItem(this.folder, 0);
        item.setText("Preview");
        item.setImage(JFaceResources.getImage((String)IMAGE_PREVIEW));
        this.swtFXContainer = new FXCanvas((Composite)this.folder, 0);
        this.swtFXContainer.setEnabled(false);
        item.setControl((Control)this.swtFXContainer);
        this.rootPane_new = new BorderPane();
        BorderPane pane = new BorderPane();
        pane.setCenter(this.rootPane_new);
        this.currentScene = this.defaultScene = new Scene((Parent)pane, -1.0, -1.0, Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D));
        this.swtFXContainer.setScene(this.defaultScene);
        this.logItem = new CTabItem(this.folder, 0);
        this.logItem.setText("Error log");
        this.logItem.setImage(JFaceResources.getImage((String)IMAGE_OK));
        this.logStatement = new Text((Composite)this.folder, 770);
        this.logStatement.setEditable(false);
        this.logItem.setControl((Control)this.logStatement);
        Menu m = new Menu((Control)this.logStatement);
        this.logStatement.setMenu(m);
        MenuItem clearItem = new MenuItem(m, 8);
        clearItem.setText("Clear Log");
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LivePreviewPart.this.logStatement.setText("");
            }
        });
        CTabItem fxmlContent = new CTabItem(this.folder, 0);
        fxmlContent.setText("FXML-Source");
        fxmlContent.setImage(JFaceResources.getImage((String)IMAGE_FXML_CONTENT));
        AnnotationModel model = new AnnotationModel();
        VerticalRuler verticalRuler = new VerticalRuler(20, (IAnnotationAccess)new AnnotationAccess());
        int styles = 68354;
        SourceViewer sourceViewer = new SourceViewer((Composite)this.folder, (IVerticalRuler)verticalRuler, styles);
        sourceViewer.configure((SourceViewerConfiguration)new XMLConfiguration(new ColorManager()));
        sourceViewer.setEditable(false);
        sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        partitioner.connect(this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        sourceViewer.setDocument(this.document);
        verticalRuler.setModel((IAnnotationModel)model);
        fxmlContent.setControl(sourceViewer.getControl());
        this.folder.setSelection(0);
        this.statusLabelIcon = new Label(container, 0);
        this.statusLabelIcon.setImage(JFaceResources.getImage((String)IMAGE_STATUS_NOPREVIEW));
        this.statusLabelText = new Label(container, 0);
        this.statusLabelText.setText(NO_PREVIEW_TEXT);
        this.statusLabelText.setLayoutData((Object)new GridData(768));
        Composite scaleControl = new Composite(container, 0);
        scaleControl.setLayoutData((Object)new GridData(3, 2, false, false));
        scaleControl.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(scaleControl, 0);
        l.setText("Zoom");
        this.scale = new Spinner(scaleControl, 2048);
        this.scale.setMinimum(10);
        this.scale.setMaximum(500);
        this.scale.setIncrement(10);
        this.scale.setSelection(100);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LivePreviewPart.this.rootPane_new.getTransforms().setAll((Object[])new Transform[]{Transform.scale((double)((double)LivePreviewPart.this.scale.getSelection() / 100.0), (double)((double)LivePreviewPart.this.scale.getSelection() / 100.0))});
                if (LivePreviewPart.this.currentFile != null) {
                    LivePreviewPart.this.scaleMap.put(LivePreviewPart.this.currentFile, LivePreviewPart.this.scale.getSelection());
                }
            }
        });
        parent.layout(true, true);
        if (this.currentData != null) {
            this.refreshContent(this.currentData);
        }
        parent.layout(true, true);
        Action loadController = new Action("", 2){

            public void run() {
                LivePreviewPart.this.preference.putBoolean(LivePreviewPart.PREF_LOAD_CONTROLLER, !LivePreviewPart.this.preference.getBoolean(LivePreviewPart.PREF_LOAD_CONTROLLER, false));
                try {
                    LivePreviewPart.this.preference.flush();
                    LivePreviewPart.this.synchronizer.refreshPreview();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        };
        loadController.setChecked(this.preference.getBoolean(PREF_LOAD_CONTROLLER, false));
        loadController.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(IMAGE_LOAD_CONTROLLER));
        loadController.setToolTipText("Load the controller");
        Action refresh = new Action("", JFaceResources.getImageRegistry().getDescriptor(IMAGE_REFRESH)){

            public void run() {
                LivePreviewPart.this.synchronizer.refreshPreview();
            }
        };
        refresh.setToolTipText("Force a refresh");
        MenuManager mgr = new MenuManager();
        SCREEN_SIZE[] sCREEN_SIZEArray = SCREEN_SIZE.values();
        int n = sCREEN_SIZEArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCREEN_SIZE s = sCREEN_SIZEArray[n2];
            mgr.add((IAction)new ScreenAction(s));
            ++n2;
        }
        final Menu m2 = mgr.createContextMenu((Control)parent);
        this.screenSize = new Action("ScreenSize", 4){

            public void runWithEvent(Event event) {
                if (event.detail == 4) {
                    ToolItem i = (ToolItem)event.widget;
                    m2.setLocation(i.getParent().toDisplay(event.x, event.y));
                    m2.setVisible(true);
                }
            }
        };
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.screenSize);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Horizontal", 2){

            public void run() {
                LivePreviewPart.this.updateResolution(LivePreviewPart.this.currentSize, this.isChecked());
            }
        });
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refresh);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)loadController);
    }

    void updateResolution(SCREEN_SIZE size, boolean horizontal) {
        this.currentSize = size;
        this.currentHorizontal = horizontal;
        this.synchronizer.refreshPreview();
    }

    public void dispose() {
        if (this.currentScene != null) {
            this.currentScene.getStylesheets().clear();
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.synchronizer);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.listener);
        super.dispose();
    }

    public void setFocus() {
        this.folder.setFocus();
    }

    private void refreshContent(final ContentData contentData) {
        this.currentData = contentData;
        if (this.folder != null && !this.folder.isDisposed()) {
            if (Thread.currentThread() == this.folder.getDisplay().getThread()) {
                try {
                    this.saveRefreshContent(contentData);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                this.folder.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LivePreviewPart.this.saveRefreshContent(contentData);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    private void saveRefreshContent(ContentData contentData) {
        FXMLLoader loader;
        this.folder.setVisible(true);
        ClassLoader cl = null;
        if (contentData.extraJarPath != null && !contentData.extraJarPath.isEmpty() && this.swtFXContainer != null) {
            PreviewURLClassloader previewClassLoader = new PreviewURLClassloader(contentData.extraJarPath.toArray(new URL[0]), this.swtFXContainer.getClass().getClassLoader());
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(previewClassLoader);
            loader = new FXMLLoader();
            loader.setBuilderFactory(new BuilderFactory(previewClassLoader){
                private BuilderFactory f;
                {
                    this.f = new JavaFXBuilderFactory((ClassLoader)uRLClassLoader);
                }

                public Builder<?> getBuilder(Class<?> type) {
                    return this.f.getBuilder(type);
                }
            });
            loader.setClassLoader((ClassLoader)previewClassLoader);
        } else {
            loader = new FXMLLoader();
        }
        final StringBuilder exception = new StringBuilder();
        try {
            ListResourceBundle b;
            block51: {
                this.currentFile = contentData.file;
                ReflectiveInvoke.setStaticLoad(loader, !this.preference.getBoolean(PREF_LOAD_CONTROLLER, false));
                try {
                    loader.setLocation(contentData.file.getParent().getLocation().toFile().getAbsoluteFile().toURI().toURL());
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                if (contentData.resourceBundle != null) {
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(new File(contentData.resourceBundle));
                            Properties p = new Properties();
                            p.load(in);
                            final Object[][] entries = new Object[p.entrySet().size()][];
                            int i = 0;
                            for (Map.Entry<Object, Object> e : p.entrySet()) {
                                entries[i++] = new Object[]{e.getKey(), e.getValue()};
                            }
                            b = new ListResourceBundle(){

                                @Override
                                protected Object[][] getContents() {
                                    return entries;
                                }
                            };
                            ResourceBundle rb = new ResourceBundle(){

                                @Override
                                protected Object handleGetObject(String key) {
                                    Object object = b.handleGetObject(key);
                                    if (object == null) {
                                        exception.append("Warning: Missing key '" + key + "'\n");
                                        object = "!" + key + "!";
                                    }
                                    return object;
                                }

                                @Override
                                public Enumeration<String> getKeys() {
                                    return b.getKeys();
                                }

                                @Override
                                public boolean containsKey(String key) {
                                    return true;
                                }
                            };
                            loader.setResources((ResourceBundle)b);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            break block51;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    ResourceBundle rb = new ResourceBundle(){

                        @Override
                        protected Object handleGetObject(String key) {
                            exception.append("Warning: No resource bundle provided\n");
                            return "!" + key + "!";
                        }

                        @Override
                        public Enumeration<String> getKeys() {
                            return Collections.emptyEnumeration();
                        }

                        @Override
                        public boolean containsKey(String key) {
                            return true;
                        }
                    };
                    loader.setResources(rb);
                }
            }
            try {
                this.document.set(contentData.contents);
                ByteArrayInputStream out = new ByteArrayInputStream(contentData.contents.getBytes());
                Object root = loader.load((InputStream)out);
                out.close();
                Scene scene = null;
                if (root instanceof Scene) {
                    scene = (Scene)root;
                    this.rootPane_new = scene.getRoot();
                } else {
                    ByteArrayInputStream sceneOut;
                    Object sceneRoot;
                    if (contentData.previewSceneSetup != null && (sceneRoot = loader.load((InputStream)(sceneOut = new ByteArrayInputStream(contentData.previewSceneSetup.getBytes())))) instanceof Scene) {
                        scene = (Scene)sceneRoot;
                    }
                    this.rootPane_new = (Node)root;
                    if (scene == null) {
                        b = new BorderPane();
                        b.setCenter(this.rootPane_new);
                        ListResourceBundle p = b;
                        ((BorderPane)this.defaultScene.getRoot()).setCenter((Node)p);
                        scene = this.defaultScene;
                    } else {
                        Node n = scene.getRoot().lookup("#previewcontainer");
                        if (n == null || !(n instanceof Parent)) {
                            n = scene.getRoot();
                        }
                        String previewFeature = null;
                        if (n.getUserData() != null && n.getUserData() != null) {
                            previewFeature = n.getUserData().toString().trim();
                        }
                        if (previewFeature != null) {
                            try {
                                String mName = "set" + Character.toUpperCase(previewFeature.charAt(0)) + previewFeature.substring(1);
                                Method m = n.getClass().getMethod(mName, Node.class);
                                m.invoke((Object)n, this.rootPane_new);
                            }
                            catch (Throwable t) {
                                String mName = "get" + Character.toUpperCase(previewFeature.charAt(0)) + previewFeature.substring(1);
                                Method m = n.getClass().getMethod(mName, new Class[0]);
                                Object o = m.invoke((Object)n, new Object[0]);
                                if (o instanceof List) {
                                    ((List)o).add(this.rootPane_new);
                                }
                            }
                        } else if (n instanceof BorderPane) {
                            ((BorderPane)n).setCenter(this.rootPane_new);
                        } else if (n instanceof Pane) {
                            ((Pane)n).getChildren().add((Object)this.rootPane_new);
                        } else {
                            throw new IllegalStateException("The parent in the scene is not a Pane. Set a preview-property styleclass on the control");
                        }
                    }
                }
                if (this.rootPane_new != null) {
                    if (this.scaleMap.containsKey(this.currentFile)) {
                        int value = this.scaleMap.get(this.currentFile);
                        this.scale.setSelection(value);
                        this.rootPane_new.getTransforms().setAll((Object[])new Transform[]{Transform.scale((double)((double)value / 100.0), (double)((double)value / 100.0))});
                    } else {
                        this.scale.setSelection(100);
                        this.rootPane_new.getTransforms().clear();
                    }
                }
                if (LivePreviewPart.isJavaFX2()) {
                    ReflectiveInvoke.onStyleManagerClass(scene);
                }
                if (this.swtFXContainer.getScene() != null) {
                    this.swtFXContainer.getScene().getStylesheets().clear();
                }
                scene.getStylesheets().addAll(contentData.cssFiles);
                this.currentScene = scene;
                this.folder.setSelection(0);
                this.swtFXContainer.setScene(scene);
                contentData.sceneGraphCallback.accept(scene.getRoot());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                exception.append(sw.toString());
            }
        }
        catch (Throwable throwable) {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (exception.length() > 0) {
            final String innerException = exception.toString();
            if (this.folder.isDisposed()) {
                return;
            }
            this.folder.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (innerException != null) {
                        LivePreviewPart.this.logItem.setImage(JFaceResources.getImage((String)IMAGE_ERROR));
                        LivePreviewPart.this.statusLabelIcon.setImage(JFaceResources.getImage((String)IMAGE_STATUS_ERROR));
                        LivePreviewPart.this.statusLabelText.setText(SimpleDateFormat.getTimeInstance().format(new Date()) + ": Error while updating preview");
                        LivePreviewPart.this.setTitleImage(JFaceResources.getImage((String)IMAGE_TAB_ERROR));
                        LivePreviewPart.this.folder.setSelection(LivePreviewPart.this.logItem);
                    }
                    LivePreviewPart.this.logStatement.setText("");
                    LivePreviewPart.this.logStatement.append("=================================================================" + LivePreviewPart.this.logStatement.getLineDelimiter());
                    LivePreviewPart.this.logStatement.append("Preview loading @ " + String.valueOf(new Date()) + LivePreviewPart.this.logStatement.getLineDelimiter());
                    LivePreviewPart.this.logStatement.append("=================================================================" + LivePreviewPart.this.logStatement.getLineDelimiter());
                    if (innerException != null) {
                        LivePreviewPart.this.logStatement.append("Exception:" + LivePreviewPart.this.logStatement.getLineDelimiter());
                        LivePreviewPart.this.logStatement.append("----------" + LivePreviewPart.this.logStatement.getLineDelimiter());
                        LivePreviewPart.this.logStatement.append(innerException + LivePreviewPart.this.logStatement.getLineDelimiter());
                        LivePreviewPart.this.logStatement.append(LivePreviewPart.this.logStatement.getLineDelimiter() + LivePreviewPart.this.logStatement.getLineDelimiter());
                        LivePreviewPart.this.logStatement.setSelection(0);
                    }
                }
            });
        } else {
            this.folder.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LivePreviewPart.this.folder.setSelection(0);
                    LivePreviewPart.this.logItem.setImage(JFaceResources.getImage((String)IMAGE_OK));
                    LivePreviewPart.this.statusLabelIcon.setImage(JFaceResources.getImage((String)IMAGE_STATUS_OK));
                    LivePreviewPart.this.statusLabelText.setText(SimpleDateFormat.getTimeInstance().format(new Date()) + ": Preview updated");
                    LivePreviewPart.this.setTitleImage(JFaceResources.getImage((String)IMAGE_TAB_NORMAL));
                }
            });
        }
    }

    public void setContents(ContentData contentData) {
        if (this.folder.isDisposed()) {
            return;
        }
        if (contentData != null && contentData.contents != null) {
            this.refreshContent(contentData);
        } else if (this.rootPane_new != null) {
            this.folder.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LivePreviewPart.this.statusLabelIcon.setImage(JFaceResources.getImage((String)IMAGE_STATUS_NOPREVIEW));
                    LivePreviewPart.this.statusLabelText.setText(LivePreviewPart.NO_PREVIEW_TEXT);
                    LivePreviewPart.this.folder.setVisible(false);
                }
            });
        }
    }

    private static boolean isJavaFX2() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("2");
    }

    public static class ContentData {
        public String contents;
        public String previewSceneSetup;
        public List<String> cssFiles;
        public String resourceBundle;
        public List<URL> extraJarPath;
        public IFile file;
        public Consumer<Object> sceneGraphCallback;

        public ContentData(String contents, String previewSceneSetup, List<String> cssFiles, String resourceBundle, List<URL> extraJarPath, IFile file, Consumer<Object> sceneGraphCallback) {
            this.contents = contents;
            this.previewSceneSetup = previewSceneSetup;
            this.cssFiles = new ArrayList<String>(cssFiles);
            this.resourceBundle = resourceBundle;
            this.extraJarPath = extraJarPath;
            this.file = file;
            this.sceneGraphCallback = sceneGraphCallback;
        }
    }

    static class PreviewURLClassloader
    extends URLClassLoader {
        public PreviewURLClassloader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return super.loadClass(name);
        }
    }

    public static enum SCREEN_SIZE {
        DEFAULT("<default>", -1, -1, false),
        IPHONE_4_RETINA("iPhone4 640\u00d7960 - Retina", 640, 960, true),
        IPHONE_5("iPhone5 640\u00d71136", 640, 1136, true),
        IPAD_DEFAULT("iPad 768\u00d71024", 768, 1024, true),
        IPAD_RETINA("iPad 1536\u00d72048 - Retina", 1536, 2048, true),
        ANDROID_PHONE_600_1024("Android 600x1024", 600, 1024, true),
        ANDROID_PHONE_720_1280("Galaxy S III 720x1280", 720, 1280, true),
        ANDROID_480_800("Galaxy Note II 480x800", 480, 800, true),
        ANDROID_720_1280("Galaxy Note II 720x1280", 720, 1280, true),
        ANDROID_800_1280("Galaxy Note II 800x1280", 800, 1280, true);

        private String name;
        private int width;
        private int height;
        private boolean supportsHorizontal;

        private SCREEN_SIZE(String name, int width, int height, boolean supportsHorizontal) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.supportsHorizontal = supportsHorizontal;
        }
    }

    class ScreenAction
    extends Action {
        private final SCREEN_SIZE size;

        public ScreenAction(SCREEN_SIZE size) {
            super(size.name, 8);
            this.size = size;
        }

        public void run() {
            LivePreviewPart.this.screenSize.setText(this.size.name);
            LivePreviewPart.this.updateResolution(this.size, LivePreviewPart.this.currentHorizontal);
        }
    }
}

