/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import jakarta.inject.Inject;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;

public class LoggerProviderImpl
implements ILoggerProvider {
    @Inject
    LoggerFactory factory;

    public Logger getClassLogger(Class<?> clazz) {
        final org.eclipse.fx.core.log.Logger logger = this.factory.createLogger(clazz.getName());
        return new Logger(){

            public void warn(Throwable t, String message) {
                if (message != null && t != null) {
                    logger.warning(message, t);
                } else if (message == null && t != null) {
                    logger.error("", t);
                } else if (message != null && t == null) {
                    logger.info(message);
                } else {
                    logger.info("<no message & no throwable>");
                }
            }

            public void trace(Throwable t, String message) {
                if (message != null && t != null) {
                    logger.trace(message, t);
                } else if (message == null && t != null) {
                    logger.trace("", t);
                } else if (message != null && t == null) {
                    logger.info(message);
                } else {
                    logger.info("<no message & no throwable>");
                }
            }

            public boolean isWarnEnabled() {
                return logger.isEnabled(Logger.Level.WARNING);
            }

            public boolean isTraceEnabled() {
                return logger.isEnabled(Logger.Level.TRACE);
            }

            public boolean isInfoEnabled() {
                return logger.isEnabled(Logger.Level.INFO);
            }

            public boolean isErrorEnabled() {
                return logger.isEnabled(Logger.Level.ERROR);
            }

            public boolean isDebugEnabled() {
                return logger.isEnabled(Logger.Level.DEBUG);
            }

            public void info(Throwable t, String message) {
                if (message != null && t != null) {
                    logger.info(message, t);
                } else if (message == null && t != null) {
                    logger.info("", t);
                } else if (message != null && t == null) {
                    logger.info(message);
                } else {
                    logger.info("<no message & no throwable>");
                }
            }

            public void error(Throwable t, String message) {
                if (message != null && t != null) {
                    logger.error(message, t);
                } else if (message == null && t != null) {
                    logger.error("", t);
                } else if (message != null && t == null) {
                    logger.info(message);
                } else {
                    logger.info("<no message & no throwable>");
                }
            }

            public void debug(Throwable t, String message) {
                if (message != null && t != null) {
                    logger.debug(message, t);
                } else if (message == null && t != null) {
                    logger.error("", t);
                } else if (message != null && t == null) {
                    logger.info(message);
                } else {
                    logger.info("<no message & no throwable>");
                }
            }

            public void debug(Throwable t) {
                if (t != null) {
                    logger.debug("", t);
                } else {
                    logger.debug("<no throwable>");
                }
            }
        };
    }
}

