/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.fx.core.TypeTypeProviderService;
import org.eclipse.fx.core.di.Service;
import org.osgi.service.component.annotations.Component;

@Component(service={ExtendedObjectSupplier.class}, property={"dependency.injection.annotation:String=org.eclipse.fx.core.di.LocalInstance"})
public class LocalInstanceObjectSupplier
extends ExtendedObjectSupplier {
    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        Requestor r = (Requestor)requestor;
        InstanceCreator instanceCreator = (InstanceCreator)r.getInjector().make(InstanceCreator.class, r.getPrimarySupplier());
        Type descriptorsClass = descriptor.getDesiredType();
        return instanceCreator.createInstance(descriptorsClass, r.getRequestingObjectClass());
    }

    private static Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    public static class InstanceCreator<O> {
        private final IEclipseContext context;
        private final List<TypeTypeProviderService<O>> providerList;

        @Inject
        public InstanceCreator(IEclipseContext context, @Service List<TypeTypeProviderService<O>> providerList) {
            this.context = context;
            this.providerList = providerList;
        }

        public O createInstance(Type iType, Class<?> owner) {
            Optional<TypeTypeProviderService> providerOp = this.providerList.stream().filter(p -> p.test((Object)iType)).findFirst();
            if (!providerOp.isPresent()) {
                return null;
            }
            Class type = providerOp.get().getType((Object)iType);
            IEclipseContext staticContext = EclipseContextFactory.create((String)"static");
            try {
                staticContext.set("localInstanceOwnerType", owner);
                Object object = ContextInjectionFactory.make((Class)type, (IEclipseContext)this.context, (IEclipseContext)staticContext);
                return (O)object;
            }
            finally {
                staticContext.dispose();
            }
        }
    }
}

