/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import java.util.function.BiFunction;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ListCell;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.core.databinding.AdapterFactory;
import org.eclipse.fx.core.databinding.ObservableWritableValue;
import org.eclipse.fx.ui.databinding.internal.TemplateComputedValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TemplateTextOnlyPropertyListCell<O>
extends ListCell<O> {
    private IObservableValue currentObservable;
    private final @NonNull IValueProperty[] properties;
    private final @NonNull String template;
    private final @Nullable BiFunction<@NonNull IValueProperty, @Nullable Object, @Nullable Object> converter;

    public TemplateTextOnlyPropertyListCell(@NonNull String template, IValueProperty ... properties) {
        this.template = template;
        this.properties = properties;
        this.converter = null;
    }

    public TemplateTextOnlyPropertyListCell(@NonNull String template, @NonNull BiFunction<@NonNull IValueProperty, @Nullable Object, @Nullable Object> converter, IValueProperty ... properties) {
        this.template = template;
        this.converter = converter;
        this.properties = properties;
    }

    protected void updateItem(O item, boolean empty) {
        super.updateItem(item, empty);
        IObservableValue oldObservable = this.currentObservable;
        this.textProperty().unbind();
        if (item != null && !empty) {
            this.currentObservable = this.converter != null ? new TemplateComputedValue(item, this.template, this.properties, this.converter) : new TemplateComputedValue(item, this.template, this.properties);
            ObservableWritableValue adapt = AdapterFactory.adapt((IObservableValue)this.currentObservable);
            this.textProperty().bind((ObservableValue)adapt);
        } else {
            this.setText(null);
        }
        if (oldObservable != null) {
            oldObservable.dispose();
        }
    }
}

