/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.hover.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import org.eclipse.fx.text.hover.DefaultHoverInfoType;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.hover.HoverPresenter;
import org.eclipse.fx.text.ui.hover.HoverWindowPresenter;
import org.eclipse.fx.text.ui.hover.internal.ResizeablePopupWindow;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;

public class DefaultHoverWindowPresenter
implements HoverWindowPresenter {
    private static boolean DEBUG_HOVER = Boolean.getBoolean("org.eclipse.fx.ui.controls.styledtext.debug");
    private List<HoverPresenter> presenters = new ArrayList<HoverPresenter>();
    private final StyledTextArea parent;
    private final ResizeablePopupWindow popup;
    private final VBox root;
    private List<HoverInfo> currentVisible;
    private boolean preventHide = false;
    private volatile Timeline hideTimeline;

    private void scheduleHide(long delay) {
        if (DEBUG_HOVER) {
            System.err.println("DefaultHoverWindowPresenter: scheduleHide(" + delay + ")");
        }
        Timeline t = new Timeline();
        t.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)delay), a -> {
            if (this.preventHide) {
                return;
            }
            if (t == this.hideTimeline) {
                this.popup.hide();
            }
        }, new KeyValue[0]));
        this.hideTimeline = t;
        t.play();
    }

    private void cancelScheduledHide() {
        if (DEBUG_HOVER) {
            System.err.println("DefaultHoverWindowPresenter: cancelScheduledHide()");
        }
        if (this.hideTimeline != null) {
            this.hideTimeline.stop();
        }
        this.hideTimeline = null;
    }

    public DefaultHoverWindowPresenter(StyledTextArea parent) {
        this.parent = parent;
        this.root = new VBox();
        this.popup = new ResizeablePopupWindow((Node)this.root);
        this.popup.setAutoFix(false);
        this.popup.setAutoHide(false);
        parent.sceneProperty().addListener(e -> {
            if (parent.getScene() != null) {
                this.popup.getScene().getStylesheets().setAll((Collection)parent.getScene().getStylesheets());
                this.parent.getScene().getWindow().focusedProperty().addListener((x, o, n) -> {
                    if (!n.booleanValue()) {
                        this.popup.hide();
                    }
                });
            } else {
                this.popup.getScene().getStylesheets().clear();
            }
        });
        this.popup.getScene().getRoot().setOnMouseExited(this::onMouseExited);
        this.popup.getScene().getRoot().setOnMouseEntered(this::onMouseEntered);
        this.root.setSpacing(3.0);
        this.root.getStyleClass().add((Object)"styled-text-hover");
    }

    public void configureWindowSize(Supplier<Point2D> windowSizeRetriever, Consumer<Point2D> windowSizePersister) {
        this.popup.configureWindowSize(windowSizeRetriever, windowSizePersister);
    }

    private void onMouseEntered(MouseEvent event) {
        if (DEBUG_HOVER) {
            System.err.println("DefaultHoverWindowPresenter: onMouseEntered()");
        }
        this.cancelScheduledHide();
        this.setDisableOnWebViews((Node)this.root, false);
    }

    private void onMouseExited(MouseEvent event) {
        if (DEBUG_HOVER) {
            System.err.println("DefaultHoverWindowPresenter: onMouseExited()");
        }
        this.scheduleHide(500L);
        this.setDisableOnWebViews((Node)this.root, true);
    }

    private Optional<HoverPresenter> findPresenter(HoverInfo hover) {
        return this.presenters.stream().filter(p -> p.isApplicable(hover)).sorted((a, b) -> b.getOrder() - a.getOrder()).findFirst();
    }

    private int compare(HoverInfo a, HoverInfo b) {
        return a.getHoverText().compareTo(b.getHoverText());
    }

    private void populate(List<HoverInfo> hovers) {
        if (this.currentVisible != null && this.currentVisible.equals(hovers)) {
            return;
        }
        this.root.getChildren().clear();
        List errors = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.ERROR).sorted(this::compare).collect(Collectors.toList());
        List warnings = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.WARNING).sorted(this::compare).collect(Collectors.toList());
        List infos = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.INFO).sorted(this::compare).collect(Collectors.toList());
        List docs = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.DOCUMENTATION).sorted(this::compare).collect(Collectors.toList());
        List others = hovers.stream().filter(h -> !errors.contains(h) && !warnings.contains(h) && !infos.contains(h) && !docs.contains(h)).sorted(this::compare).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            VBox errorNode = new VBox();
            errorNode.getStyleClass().add((Object)"errors");
            errorNode.getChildren().addAll((Collection)errors.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)errorNode);
        }
        if (!warnings.isEmpty()) {
            VBox warnNode = new VBox();
            warnNode.getStyleClass().add((Object)"warnings");
            warnNode.getChildren().addAll((Collection)warnings.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)warnNode);
        }
        if (!infos.isEmpty()) {
            VBox infoNode = new VBox();
            infoNode.getStyleClass().add((Object)"infos");
            infoNode.getChildren().addAll((Collection)infos.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)infoNode);
        }
        if (!docs.isEmpty()) {
            VBox docsNode = new VBox();
            docsNode.getStyleClass().add((Object)"docs");
            docsNode.getChildren().addAll((Collection)docs.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)docsNode);
        }
        if (!others.isEmpty()) {
            VBox othersNode = new VBox();
            othersNode.getStyleClass().add((Object)"others");
            othersNode.getChildren().addAll((Collection)others.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)othersNode);
        }
        this.currentVisible = hovers;
        this.setDisableOnWebViews((Node)this.root, true);
    }

    void setDisableOnWebViews(Node cur, boolean state) {
        if (cur instanceof WebView) {
            cur.setDisable(state);
        } else if (cur instanceof Parent) {
            ((Parent)cur).getChildrenUnmodifiable().forEach(n -> this.setDisableOnWebViews((Node)n, state));
        }
    }

    @Override
    public void show(Point2D screenAnchor, Bounds screenBounds, List<HoverInfo> hover) {
        this.cancelScheduledHide();
        this.populate(hover);
        this.popup.show(this.parent.getScene().getWindow(), screenAnchor.getX(), screenAnchor.getY(), this.parent.getFixedLineHeight());
    }

    @Override
    public void hide() {
        this.scheduleHide(300L);
    }

    public void setHoverPresenter(List<HoverPresenter> hoverPresenters) {
        this.presenters = hoverPresenters;
    }
}

