/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;

public abstract class SelectionHandlesEditPolicy
extends SelectionEditPolicy
implements IAdaptable {
    protected List handles;

    protected void addSelectionHandles() {
        this.removeSelectionHandles();
        IFigure layer = this.getLayer("Handle Layer");
        this.handles = this.createSelectionHandles();
        for (Object handle : this.handles) {
            layer.add((IFigure)handle);
        }
    }

    protected abstract List createSelectionHandles();

    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleHandleProvider.class) {
            return key.cast(new AccessibleHandleProvider(){

                @Override
                public List<Point> getAccessibleHandleLocations() {
                    ArrayList<Point> result = new ArrayList<Point>();
                    if (SelectionHandlesEditPolicy.this.handles != null) {
                        for (Object handle : SelectionHandlesEditPolicy.this.handles) {
                            Point p = ((Handle)handle).getAccessibleLocation();
                            if (p == null) continue;
                            result.add(p);
                        }
                    }
                    return result;
                }
            });
        }
        return null;
    }

    @Override
    protected void hideSelection() {
        this.removeSelectionHandles();
    }

    protected void removeSelectionHandles() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (Object handle : this.handles) {
            layer.remove((IFigure)handle);
        }
        this.handles = null;
    }

    @Override
    protected void showSelection() {
        this.addSelectionHandles();
    }
}

