/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCClient.java 75018 2017-06-01 21:59:20Z jsupol $
 */
package com.sun.ts.tests.websocket.negdep.onclose.srv.duplicate;

import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 *                     ws_wait;
 *                     tslib.name;
 */
/**
 * @since 1.11
 */
public class WSCClient extends NegativeDeploymentClient {

	private static final long serialVersionUID = 111L;

	public WSCClient() {
		setContextRoot("wsc_negdep_onclose_srv_duplicate_web");
	}

	public static void main(String[] args) {
		new WSCClient().run(args);
	}

	/*
	 * @testName: multipleOnCloseRemovesAllEndpointsTest
	 * @assertion_ids:  WebSocket:SPEC:WSC-5.2.1-3;WebSocket:SPEC:WSC-4.5-4;
	 * @test_Strategy: In both cases, a deployment error raised during the 
	 * deployment process must halt the deployment of the application, any 
	 * well formed endpoints deployed prior to the error being raised must be 
	 * removed from service and no more websocket endpoints from that 
	 * application may be deployed by the container, even if they are valid.
	 * 
	 * Any Java class using this annotation on a method that does not follow 
	 * these rules, or that uses this annotation on more than one method may 
	 * not be deployed by the implementation and the error reported to the 
	 * deployer. [WSC-4.5-4]
	 * 
	 * To verify the test fails when the deployment was successful, comment out  
	 * one of @OnClose in OnCloseServerEndpoint 
	 */
	public void multipleOnCloseRemovesAllEndpointsTest() throws Fault {
		setProperty(Property.CONTENT, "anything");
		setProperty(Property.REQUEST, buildRequest("echo"));
		setProperty(Property.STATUS_CODE, "-1");
		// logExceptionOnInvocation(false);
		try {
			invoke(false);
		} catch (Fault tfe) {
			// DeploymentException
		}
		String response = getResponseAsString();
		if ("anything".equals(response))
			throwValidEndpointMustBeRemoved();
	}

	/*
	 * @testName: multipleOnCloseTest
	 * @assertion_ids:  WebSocket:SPEC:WSC-5.2.1-3;WebSocket:SPEC:WSC-4.5-4;
	 * @test_Strategy: In both cases, a deployment error raised during the 
	 * deployment process must halt the deployment of the application, any 
	 * well formed endpoints deployed prior to the error being raised must be 
	 * removed from service and no more websocket endpoints from that 
	 * application may be deployed by the container, even if they are valid.
	 * 
	 * Any Java class using this annotation on a method that does not follow 
	 * these rules, or that uses this annotation on more than one method may 
	 * not be deployed by the implementation and the error reported to the 
	 * deployer. [WSC-4.5-4]
	 * 
	 * To verify the test fails when the deployment was successful, comment out  
	 * one of @OnClose in OnCloseServerEndpoint 
	 */
	public void multipleOnCloseTest() throws Fault {
		setProperty(Property.CONTENT, "anything");
		setProperty(Property.REQUEST, buildRequest("invalid"));
		setProperty(Property.STATUS_CODE, "-1");
		// logExceptionOnInvocation(false);
		try {
			invoke(false);
		} catch (Fault tfe) {
			// DeploymentException
		}
		String response = getResponseAsString();
		if (response.contains("anything"))
			throwValidEndpointMustBeRemoved();		
	}
}
