/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: WSByteBufferAndPathParamServer.java 72135 2013-06-13 09:13:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint("/bytebufferpathparam/{param}")
public class WSByteBufferAndPathParamServer {
	@OnMessage
	public String echo(@PathParam("param") String param, ByteBuffer b) {
		return IOUtil.byteBufferToString(b) + param;
	}

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	System.out.println("@OnError in" + getClass().getName());
    	t.printStackTrace(); //Write to error log, too
    	String message = "Exception: " + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }
}
