/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringTextMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;

public class StringTextMessageHandler implements MessageHandler.Whole<String>{

	ClientEndpoint<String> endpoint;
	public static final String HANDLER_SAYS = "StringTextMessageHandler says: ";
	
	public StringTextMessageHandler(ClientEndpoint<String> endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(String message) {
		endpoint.onMessage(HANDLER_SAYS + message);
	}

}
