/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ReaderMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.io.IOException;
import java.io.Reader;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ReaderMessageHandler implements MessageHandler.Whole<Reader>{
	ClientEndpoint<String> endpoint;
	
	public static final String HANDLER_SAYS = "ReaderMessageHandler says: ";

	public ReaderMessageHandler(ClientEndpoint<String> endpoint) {
		this.endpoint = endpoint;
	}	
	
	@Override
	public void onMessage(Reader message) {
		String msg = null;
		try {
			msg = IOUtil.readFromReader(message);
		} catch (IOException e) {
			throw new RuntimeException(e); 
		}
		endpoint.onMessage(HANDLER_SAYS + msg);
	}

}
