/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCMsgServer.java 72835 2013-09-09 16:00:58Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.server;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/msg")
public class WSCMsgServer {
	static final String EMPTY = "empty";
	static final String MESSAGES[] = { "reset", "lastmsg" };
	static String message = EMPTY;

	@OnMessage
	public String onMessage(String msg, Session session) {
		if (MESSAGES[0].equals(msg)) {
			setLastMessage(EMPTY);
		}
		msg = getLastMessage();
		return msg;
	}

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}

	private static String getLastMessage() {
		return message;
	}

	public static void setLastMessage(String lastMessage) {
		WSCMsgServer.message = lastMessage;
	}

}
