/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.securitycontext.callerdata;

import java.io.IOException;
import java.util.List;

import javax.annotation.security.DeclareRoles;
import javax.inject.Inject;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */

@BasicAuthenticationMechanismDefinition(
    realmName="test realm"
)

@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/servlet")
@ServletSecurity(@HttpConstraint(rolesAllowed = "Administrator"))
public class Servlet extends HttpServlet {

    private static final long serialVersionUID = 1L;
    
    @Inject
    private SecurityContext securityContext;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        response.getWriter().write("This is a servlet \n");
        
        String contextName = null;
        if (securityContext.getCallerPrincipal() != null) {
            contextName = securityContext.getCallerPrincipal().getName();
        }
        
        response.getWriter().write("context username: " + contextName + "\n");
        
        response.getWriter().write("context user has role \"Administrator\": " + securityContext.isCallerInRole("Administrator") + "\n");
        response.getWriter().write("context user has role \"Manager\": " + securityContext.isCallerInRole("Manager") + "\n");
        response.getWriter().write("context user has role \"Employee\": " + securityContext.isCallerInRole("Employee") + "\n");
        
        response.getWriter().write("isCallerInRole(Administrator) result same with request.isUserInRole(Administrator) result : " 
            + (securityContext.isCallerInRole("Administrator") == request.isUserInRole("Administrator")));
        response.getWriter().write("isCallerInRole(Manager) result same with request.isUserInRole(Manager) result : " 
                + (securityContext.isCallerInRole("Manager") == request.isUserInRole("Manager")));
        response.getWriter().write("isCallerInRole(Employee) result same with request.isUserInRole(Employee) result : " 
                + (securityContext.isCallerInRole("Employee") == request.isUserInRole("Employee")));
    }

}
