package com.sun.ts.tests.securityapi.idstore.common;

import javax.security.enterprise.credential.Credential;

public class CustomCredential implements Credential{
    private final String caller;    
    private final String password;

    public CustomCredential(String callerName, String pwd) {
        this.caller = callerName;
        this.password = pwd;
    }

    public String getCaller() {
        return caller;
    }
    
    public String getPassword() {
        return password;
    }

    public boolean compareTo(String callerName, String pwd) {
        return getCaller().equals(callerName) && getPassword().equals(pwd);
    }
}
