/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MySimpleTag.java 62554 2011-04-15 18:08:28Z dougd $ 
 */

package com.sun.ts.tests.jsp.spec.tagfiles.semantics;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.SkipPageException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class MySimpleTag extends SimpleTagSupport 
    implements TryCatchFinally{
    
    public void doTag() throws JspException {
        try {
            JspWriter out = getJspContext().getOut();
            out.println("Test PASSED. MySimpleTag.doTag");
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        throw new SkipPageException("from MySimpleTag.doTag.");
    }

    public void doCatch(Throwable t) throws Throwable {
        try {
            JspWriter out = getJspContext().getOut();
            out.println("MySimpleTag.doCatch");
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        
    }

    public void doFinally() {

    }
}
