/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.spec.core_syntax.scripting.escaping;

import java.io.PrintWriter;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsp.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setGeneralURI("/jsp/spec/core_syntax/scripting/escaping");
        setContextRoot("/jsp_coresyntx_script_escape_web");

        return super.run(args, out, err);
    }
    
    /*
     *  @class.setup_props: webServerHost;
     *                      webServerPort;
     *                      ts_home; 
     */
     
    /* Run tests */
  
    //============================================ Tests ======
  
    /*
     * @testName: positiveEscapingTest
     * @assertion_ids: JSP:SPEC:7
     * @testStrategy: Validate handling of escaped entities.
     */
    public void positiveEscapingTest() throws Fault {
        TEST_PROPS.setProperty(STANDARD, "positiveEscapingTest");
        invoke();
    }
}
