/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SyncTEI.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)SyncTEI.java 1.1 11/06/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import javax.servlet.jsp.tagext.TagData;

/**
 * Simple TEI to export AT_BEGIN and AT_END variables.
 */
public class SyncTEI extends TagExtraInfo {

    /**
     * Default constructor.
     */
    public SyncTEI() {
        super();
    }

    /**
     * Exports 'begin' with scope of AT_BEGIN, and 'end' with scope
     * of AT_END.
     * @param data - TagData instance
     * @return an array of VariableInfos
     */
    public VariableInfo[] getVariableInfo(TagData data) {
        JspTestUtil.debug("[SyncTEI] in getVariableInfo()");
        return new VariableInfo[] {
            new VariableInfo("begin", "java.lang.Integer", true, VariableInfo.AT_BEGIN),
            new VariableInfo("end", "java.lang.Integer", true, VariableInfo.AT_END)
        };
    }
}
