/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.beanelresolver;

import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.BeanELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class BeanELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

        StringBuffer buf = new StringBuffer();
        String property = "intention";

        SimpleBean bean = new SimpleBean();
        bean.setIntention("bad");
        
        JspWriter out = getJspContext().getOut();
        ELContext context = getJspContext().getELContext();
        BeanELResolver beanResolver = new BeanELResolver(); 

        try {
            boolean pass = ResolverTest.testELResolver(context,
                    beanResolver, bean, property, "good", buf, false); 
            out.println(buf.toString());
            if (pass == true) out.println("Test PASSED");
        } catch (Throwable t) {
            out.println("contents of buffer:\n" + buf.toString());
            JspTestUtil.handleThrowable(t, out, "BeanELResolverTag");
        }
    }
} 
