/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.event.ajaxbehaviorevent;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseBehaviorEventTestServlet;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.Behavior;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;

public class TestServlet extends BaseBehaviorEventTestServlet {

    private static final UICommand uic = new UICommand();
    private static final Behavior behavior = new AjaxBehavior();

    @Override
    protected BehaviorEvent createEvent(UIComponent component,
            Behavior behavior) {
        return new AjaxBehaviorEvent(component, behavior) ;
    }

    @Override
    protected Behavior getTestBehavior() {
        return behavior;
    }

    @Override
    protected UIComponent getTestComponent() {
        return uic;
    }

    //------------------------------------------------------------- test methods
}
