/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jaxws/wsi/w2j/rpc/literal/R2751/Client.java $ $LastChangedDate: 2011-04-21 07:51:41 -0700 (Thu, 21 Apr 2011) $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2751;

import com.sun.ts.lib.harness.*;

import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.wsi.requests.SOAPRequests;
import com.sun.javatest.Status;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPElement;
import java.util.Properties;
import java.util.Iterator;
import java.io.InputStream;

public class Client extends ServiceEETest implements SOAPRequests{

    private W2JRLR2751Client client;

    
    static W2JRLR2751TestService service = null;

    /**
     * Test entry point.
     *
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }


    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void setup(String[] args, Properties properties) throws EETest.Fault {
        client = (W2JRLR2751Client)ClientFactory.getClient(W2JRLR2751Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup(){
        logMsg("cleanup");
    }

    /**
     * @testName: IndependentOrderOfHeadersTest
     *
     * @assertion_ids: WSI:SPEC:R2751
     *
     * @test_Strategy: Send a SOAP request that has the headers 
     *                 in a different order than they are defined in
     *                 the wsdl. The endpoint checks for their correctness.
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void IndependentOrderOfHeadersTest() throws EETest.Fault {
        SOAPMessage response;
        try{
            response = client.makeSaajRequest(R2751_REQUEST);
        }catch(Exception e){
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
    }
}
