/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR2114Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2114;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;


public class W2JRLR2114Client extends SOAPClient {
    public W2JRLR2114Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this(webServerHost, webServerPort, mode, null);
    }

    public W2JRLR2114Client(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr2114testservice.org/W2JRLR2114TestService.wsdl");
        stubContext.setService("W2JRLR2114TestService");
        stubContext.setPort("W2JRLR2114TestPort");
        stubContext.setEndpointInterface(W2JRLR2114Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr2114.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr2114.wsdlloc.1";
    }

    public String echoIncludedStringTest(String str) throws Exception {
        IncludedStringRequest srq = new IncludedStringRequest();
        srq.setStringValue(str); 
        IncludedStringResponse srp= ((W2JRLR2114Test)stubContext.getStub()).echoIncludedStringTest(srq);
        return srp.getStringValue();
    }
}
