/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.j2w.rpc.literal.R2306;

import java.util.Properties;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.rpclitclient.*;
import com.sun.ts.tests.jaxws.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxws.wsi.utils.DescriptionUtils;
import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements DescriptionConstants {
    /**
     * The client.
     */
    private SOAPClient client;
    
    
    static J2WRLShared service = null;

    /**
     * The document.
     */
    private Document document;

    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client test = new Client();
        Status status = test.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = ClientFactory.getClient(J2WRLSharedClient.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testMessageParts
     *
     * @assertion_ids: WSI:SPEC:R2306
     *
     * @test_Strategy: Retrieve the WSDL, generated by the Java-to-WSDL tool,
     * and examine the port type(s) making sure they have correct, valid messages.
     *
     * @throws Fault
     */
    public void testMessageParts() throws Fault {
        document = client.getDocument();
        Element[] portTypes = DescriptionUtils.getPortTypes(document);
        for (int i = 0; i < portTypes.length; i++) {
            verifyPortType(portTypes[i]);
        }
    }
    
    protected void verifyPortType(Element element) throws Fault {
        Element[] children = DescriptionUtils.getChildElements(element, WSDL_NAMESPACE_URI, WSDL_OPERATION_LOCAL_NAME);
        for (int i = 0; i < children.length; i++) {
            verifyOperation(children[i]);
        }
    }
    
    protected void verifyOperation(Element element) throws Fault {
        Element input = getInput(element);
        if (input != null) {
            Element message = getMessage(input);
            verifyMessage(message);
        }
        Element output = getOutput(element);
        if (output != null) {
            Element message = getMessage(output);
            verifyMessage(message);
        }
    }
    
    protected void verifyMessage(Element element) throws Fault {
        Element[] children = DescriptionUtils.getChildElements(element, WSDL_NAMESPACE_URI, WSDL_PART_LOCAL_NAME);
        for (int i = 0; i < children.length; i++) {
            Attr attr;
            attr = children[i].getAttributeNode(WSDL_TYPE_ATTR);
            if (attr == null) {
                return;
            }
            attr = children[i].getAttributeNode(WSDL_ELEMENT_ATTR);
            if (attr != null) {
                String messageName = element.getAttribute(WSDL_NAME_ATTR);
                String partName = children[i].getAttribute(WSDL_NAME_ATTR);
                throw new Fault("Part '" + partName + "' in message '" + messageName + "' references both a type and an element (BP-R2306)");
            }

        }
    }
    
    protected Element getOutput(Element element) throws Fault {
        Element[] children = DescriptionUtils.getChildElements(element, WSDL_NAMESPACE_URI, WSDL_OUTPUT_LOCAL_NAME);
        if (children.length > 0) {
            return children[0];
        }
        return null;
    }
    
    protected Element getInput(Element element) throws Fault {
        Element[] children = DescriptionUtils.getChildElements(element, WSDL_NAMESPACE_URI, WSDL_INPUT_LOCAL_NAME);
        if (children.length > 0) {
            return children[0];
        }
        return null;
    }
    
    protected Element getMessage(Element element) throws Fault {
        String message = element.getAttribute(DescriptionUtils.WSDL_MESSAGE_ATTR);
        int index = message.indexOf(':');
        if (index == -1) {
            throw new Fault("In- or output element refers to unqualified message name '" + message + "' (BP-R2306)");
        }
        String localName = message.substring(index + 1);
        Element[] children = DescriptionUtils.getChildElements(document, WSDL_NAMESPACE_URI, WSDL_MESSAGE_LOCAL_NAME);
        for (int i = 0; i < children.length; i++) {
            String name = children[i].getAttribute(WSDL_NAME_ATTR);
            if (name.equals(localName)) {
                return children[i];
            }
        }
        throw new Fault("Message '" + localName + "' not found (BP-R2306)");
    }
}
