/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: NonAnonymousRespProcessor2.java 52501 2007-01-24 02:29:49Z af70133 $
 */

package com.sun.ts.tests.jaxws.wsa.j2w.document.literal.anonymous;

import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.*;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPException;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.io.IOException;

/**
 * This class handles the non-anonymous FaultTo responses
 * @author Alan Frechette
 */
@WebServiceProvider
@ServiceMode(value = Service.Mode.MESSAGE)
public class NonAnonymousRespProcessor2 implements Provider<SOAPMessage> {
    Exchanger<SOAPMessage> msgExchanger;

    public NonAnonymousRespProcessor2() {}

    public NonAnonymousRespProcessor2( Exchanger<SOAPMessage> msgExchanger) {
        this.msgExchanger = msgExchanger;
    }

    public SOAPMessage invoke(SOAPMessage request) {
        System.out.printf("====%s[start:%tc]====\n", getClass().getName(), Calendar.getInstance());
        try {
            request.writeTo(System.out);
        } catch (SOAPException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("====%s[end:%tc]====\n", getClass().getName(), Calendar.getInstance());
        try {
            msgExchanger.exchange(request, 30L, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }  
}
