/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SoapFaultTestImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved. */
package com.sun.ts.tests.jaxws.sharedwebservices.faultservice;

import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.namespace.QName;
import javax.xml.soap.*;
import javax.xml.ws.WebServiceException;
import java.rmi.ServerException;

@javax.jws.WebService(
    targetNamespace="http://faulttestservice.org/wsdl",
    portName="SoapFaultTestPort",
    serviceName="FaultTest",
    endpointInterface="com.sun.ts.tests.jaxws.sharedwebservices.faultservice.SoapFaultTest"
)
public class SoapFaultTestImpl implements SoapFaultTest{
    public String alwaysThrowsException() throws DummyException{
        throw new DummyException("dummyString1", "dummyString2");
    }

    public String alwaysThrowsServerException() throws ServerException{
        throw new ServerException("alwaysThrowsServerException");
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoChildren() {
        try{
	    SOAPFault sf = SOAPFactory.newInstance().createFault("This always throws a SOAPFaultException", new QName("Server"));
	    sf.setFaultActor("http://a.dummy.uri");
	    sf.addDetail();
	    throw new SOAPFaultException(sf);
        }catch(SOAPException se){
            throw new WebServiceException(se.toString(), se);
        }
    }

    public String alwaysThrowsSOAPFaultExceptionDetailUnqualifiedChildren() {
        try{
	    SOAPFault sf = SOAPFactory.newInstance().createFault("This always throws a SOAPFaultException", new QName("Server"));
	    sf.setFaultActor("http://a.dummy.uri");
	    sf.addDetail();
            sf.getDetail().addDetailEntry(getName("dummyLocalName"));
	    throw new SOAPFaultException(sf);
        }catch(SOAPException se){
            throw new WebServiceException(se.toString(), se);
        }
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedChildren() {
        try{
	    SOAPFault sf = SOAPFactory.newInstance().createFault("This always throws a SOAPFaultException", new QName("Server"));
	    sf.setFaultActor("http://a.dummy.uri");
	    sf.addDetail();
            sf.getDetail().addDetailEntry(getName("dummyLocalName", "dummyPrefix", "http://dummyURI.org"));
	    throw new SOAPFaultException(sf);
        }catch(SOAPException se){
            throw new WebServiceException(se.toString(), se);
        }
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoAttributes()  {
        try{
	    SOAPFault sf = SOAPFactory.newInstance().createFault("This always throws a SOAPFaultException", new QName("Server"));
	    sf.setFaultActor("http://a.dummy.uri");
	    sf.addDetail();
	    throw new SOAPFaultException(sf);
        }catch(SOAPException se){
            throw new WebServiceException(se.toString(), se);
        }
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedAttributes()  {
        try{
	    SOAPFault sf = SOAPFactory.newInstance().createFault("This always throws a SOAPFaultException", new QName("Server"));
	    sf.setFaultActor("http://a.dummy.uri");
	    sf.addDetail();
            sf.getDetail().addAttribute(getName("dummyLocalName", "dummyPrefix", "http://dummyURI.org"), "dummyValue");
	    throw new SOAPFaultException(sf);
        }catch(SOAPException se){
            throw new WebServiceException(se.toString(), se);
        }
    }

    private Name getName(String localName)throws SOAPException{
        return getName(localName, null, null);
    }

    private Name getName(String localName, String prefix, String uri) throws SOAPException{
        if(prefix == null && uri == null){
            return MessageFactory.newInstance().createMessage().getSOAPPart().getEnvelope().createName(localName);
        }
        else{
            return MessageFactory.newInstance().createMessage().getSOAPPart().getEnvelope().createName(localName, prefix, uri);
        }
    }
}
