/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.document.literal.onewayhandlertest.server;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import com.sun.ts.tests.jaxws.common.*;

import javax.xml.ws.*;
import javax.xml.ws.handler.*;
import javax.xml.ws.handler.soap.*;

import javax.xml.ws.WebServiceException;

import java.io.*;
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import java.util.Vector;
import javax.xml.ws.handler.MessageContext;
import javax.activation.DataHandler;
import java.util.Properties;



// Service Implementation Class - as outlined in JAX-WS Specification

import javax.jws.WebService;
import javax.annotation.Resource;

@WebService(
    portName="HelloPort",
    targetNamespace="http://dlowhandlertestservice.org/wsdl",
    serviceName="DLOWHandlerTestService",
    wsdlLocation="WEB-INF/wsdl/WSDLOWHandlerTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.ee.w2j.document.literal.onewayhandlertest.server.Hello"
)

public class HelloImpl implements Hello {

    public void doHandlerTest1(com.sun.ts.tests.jaxws.ee.w2j.document.literal.onewayhandlertest.server.MyAction action)  {

     Handler_Util.setTraceFlag(action.getHarnesslogtraceflag());

     Handler_Util.initTestUtil("HelloImpl",
                               action.getHarnessloghost(),
                               action.getHarnesslogport(), 
                               action.getHarnesslogtraceflag());

     TestUtil.logTrace("*** in HelloImpl:doHandlerTest1 ***");
     String theAction = action.getAction();
     TestUtil.logTrace("*** action = "+theAction+" ***");
     String testType = action.getTestType();
     TestUtil.logTrace("*** testType = "+testType+" ***");
  }
}
