/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ConcurrentRequestLimiterRequestHandler
extends LDAPListenerRequestHandler {
    private final LDAPListenerRequestHandler downstreamRequestHandler;
    private final long rejectTimeoutMillis;
    private final Semaphore abandonSemaphore;
    private final Semaphore addSemaphore;
    private final Semaphore bindSemaphore;
    private final Semaphore compareSemaphore;
    private final Semaphore deleteSemaphore;
    private final Semaphore extendedSemaphore;
    private final Semaphore modifySemaphore;
    private final Semaphore modifyDNSemaphore;
    private final Semaphore searchSemaphore;

    public ConcurrentRequestLimiterRequestHandler(LDAPListenerRequestHandler downstreamRequestHandler, int maxConcurrentRequests, long rejectTimeoutMillis) {
        this(downstreamRequestHandler, new Semaphore(maxConcurrentRequests), rejectTimeoutMillis);
    }

    public ConcurrentRequestLimiterRequestHandler(LDAPListenerRequestHandler downstreamRequestHandler, Semaphore semaphore, long rejectTimeoutMillis) {
        this(downstreamRequestHandler, null, semaphore, semaphore, semaphore, semaphore, semaphore, semaphore, semaphore, semaphore, rejectTimeoutMillis);
    }

    public ConcurrentRequestLimiterRequestHandler(LDAPListenerRequestHandler downstreamRequestHandler, Semaphore abandonSemaphore, Semaphore addSemaphore, Semaphore bindSemaphore, Semaphore compareSemaphore, Semaphore deleteSemaphore, Semaphore extendedSemaphore, Semaphore modifySemaphore, Semaphore modifyDNSemaphore, Semaphore searchSemaphore, long rejectTimeoutMillis) {
        Validator.ensureNotNull(downstreamRequestHandler);
        this.downstreamRequestHandler = downstreamRequestHandler;
        this.abandonSemaphore = abandonSemaphore;
        this.addSemaphore = addSemaphore;
        this.bindSemaphore = bindSemaphore;
        this.compareSemaphore = compareSemaphore;
        this.deleteSemaphore = deleteSemaphore;
        this.extendedSemaphore = extendedSemaphore;
        this.modifySemaphore = modifySemaphore;
        this.modifyDNSemaphore = modifyDNSemaphore;
        this.searchSemaphore = searchSemaphore;
        this.rejectTimeoutMillis = rejectTimeoutMillis >= 0L ? rejectTimeoutMillis : Integer.MAX_VALUE;
    }

    @Override
    public ConcurrentRequestLimiterRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new ConcurrentRequestLimiterRequestHandler(this.downstreamRequestHandler.newInstance(connection), this.abandonSemaphore, this.addSemaphore, this.bindSemaphore, this.compareSemaphore, this.deleteSemaphore, this.extendedSemaphore, this.modifySemaphore, this.modifyDNSemaphore, this.searchSemaphore, this.rejectTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.abandonSemaphore, OperationType.ABANDON);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return;
        }
        try {
            this.downstreamRequestHandler.processAbandonRequest(messageID, request, controls);
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.abandonSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.addSemaphore, OperationType.ADD);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processAddRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.addSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.bindSemaphore, OperationType.BIND);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processBindRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.bindSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.compareSemaphore, OperationType.COMPARE);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processCompareRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.compareSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.deleteSemaphore, OperationType.DELETE);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processDeleteRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.deleteSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.extendedSemaphore, OperationType.EXTENDED);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processExtendedRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.extendedSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.modifySemaphore, OperationType.MODIFY);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processModifyRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.modifySemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.modifyDNSemaphore, OperationType.MODIFY_DN);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processModifyDNRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.modifyDNSemaphore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        try {
            this.acquirePermit(this.searchSemaphore, OperationType.SEARCH);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(le.toLDAPResult()), new Control[0]);
        }
        try {
            LDAPMessage lDAPMessage = this.downstreamRequestHandler.processSearchRequest(messageID, request, controls);
            return lDAPMessage;
        }
        finally {
            ConcurrentRequestLimiterRequestHandler.releasePermit(this.searchSemaphore);
        }
    }

    private void acquirePermit(Semaphore semaphore, OperationType operationType) throws LDAPException {
        if (semaphore == null) {
            return;
        }
        try {
            if (this.rejectTimeoutMillis == 0L) {
                if (!semaphore.tryAcquire()) {
                    throw new LDAPException(ResultCode.BUSY, ListenerMessages.ERR_CONCURRENT_LIMITER_REQUEST_HANDLER_NO_TIMEOUT.get(operationType.name()));
                }
            } else if (!semaphore.tryAcquire(this.rejectTimeoutMillis, TimeUnit.MILLISECONDS)) {
                throw new LDAPException(ResultCode.BUSY, ListenerMessages.ERR_CONCURRENT_LIMITER_REQUEST_HANDLER_TIMEOUT.get(operationType.name(), this.rejectTimeoutMillis));
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.OTHER, ListenerMessages.ERR_CONCURRENT_LIMITER_REQUEST_HANDLER_SEMAPHORE_EXCEPTION.get(operationType.name(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static void releasePermit(Semaphore semaphore) {
        if (semaphore != null) {
            semaphore.release();
        }
    }
}

