/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import jdk.incubator.http.internal.frame.Http2Frame;

public abstract class ErrorFrame
extends Http2Frame {
    public static final int NO_ERROR = 0;
    public static final int PROTOCOL_ERROR = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int FLOW_CONTROL_ERROR = 3;
    public static final int SETTINGS_TIMEOUT = 4;
    public static final int STREAM_CLOSED = 5;
    public static final int FRAME_SIZE_ERROR = 6;
    public static final int REFUSED_STREAM = 7;
    public static final int CANCEL = 8;
    public static final int COMPRESSION_ERROR = 9;
    public static final int CONNECT_ERROR = 10;
    public static final int ENHANCE_YOUR_CALM = 11;
    public static final int INADEQUATE_SECURITY = 12;
    public static final int HTTP_1_1_REQUIRED = 13;
    static final int LAST_ERROR = 13;
    static final String[] errorStrings = new String[]{"Not an error", "Protocol error", "Internal error", "Flow control error", "Settings timeout", "Stream is closed", "Frame size error", "Stream not processed", "Stream cancelled", "Compression state not updated", "TCP Connection error on CONNECT", "Processing capacity exceeded", "Negotiated TLS parameters not acceptable", "Use HTTP/1.1 for request"};
    int errorCode;

    public static String stringForCode(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 13) {
            return "Error: " + Integer.toString(n);
        }
        return errorStrings[n];
    }

    public ErrorFrame(int n, int n2, int n3) {
        super(n, n2);
        this.errorCode = n3;
    }

    @Override
    public String toString() {
        return super.toString() + " Error: " + ErrorFrame.stringForCode(this.errorCode);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }
}

