/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ListNotificationSubscriptionsExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ListNotificationSubscriptionsExtendedRequest
extends ExtendedRequest {
    public static final String LIST_NOTIFICATION_SUBSCRIPTIONS_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.40";
    private static final long serialVersionUID = -8124073083247944273L;
    private final Set<String> destinationIDs;
    private final String managerID;

    public ListNotificationSubscriptionsExtendedRequest(String managerID, String ... destinationIDs) {
        this(managerID, StaticUtils.toList(destinationIDs), new Control[0]);
    }

    public ListNotificationSubscriptionsExtendedRequest(String managerID, Collection<String> destinationIDs, Control ... controls) {
        super(LIST_NOTIFICATION_SUBSCRIPTIONS_REQUEST_OID, ListNotificationSubscriptionsExtendedRequest.encodeValue(managerID, destinationIDs), controls);
        this.managerID = managerID;
        this.destinationIDs = destinationIDs == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(destinationIDs));
    }

    public ListNotificationSubscriptionsExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_NOTIFICATION_SUBS_REQ_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.managerID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            if (elements.length > 1) {
                ASN1Element[] destIDElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                LinkedHashSet<String> destIDs = new LinkedHashSet<String>(destIDElements.length);
                for (ASN1Element e : destIDElements) {
                    destIDs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                }
                this.destinationIDs = Collections.unmodifiableSet(destIDs);
            } else {
                this.destinationIDs = Collections.emptySet();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_NOTIFICATION_SUBS_REQ_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(String managerID, Collection<String> destinationIDs) {
        Validator.ensureNotNull(managerID);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(managerID));
        if (destinationIDs != null && !destinationIDs.isEmpty()) {
            LinkedHashSet<ASN1OctetString> destIDElements = new LinkedHashSet<ASN1OctetString>(destinationIDs.size());
            for (String destinationID : destinationIDs) {
                destIDElements.add(new ASN1OctetString(destinationID));
            }
            elements.add(new ASN1Set(destIDElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    public ListNotificationSubscriptionsExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new ListNotificationSubscriptionsExtendedResult(extendedResponse);
    }

    public String getManagerID() {
        return this.managerID;
    }

    public Set<String> getDestinationIDs() {
        return this.destinationIDs;
    }

    @Override
    public ListNotificationSubscriptionsExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ListNotificationSubscriptionsExtendedRequest duplicate(Control[] controls) {
        ListNotificationSubscriptionsExtendedRequest r = new ListNotificationSubscriptionsExtendedRequest(this.managerID, this.destinationIDs, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_LIST_NOTIFICATION_SUBS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("ListNotificationSubscriptionsExtendedRequest(managerID='");
        buffer.append(this.managerID);
        buffer.append('\'');
        if (!this.destinationIDs.isEmpty()) {
            buffer.append(", destinationIDs={");
            Iterator<String> iterator = this.destinationIDs.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

