/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.AttributeRight;
import com.unboundid.ldap.sdk.unboundidds.controls.EntryRight;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EffectiveRightsEntry
extends ReadOnlyEntry {
    private static final String ATTR_ACL_RIGHTS = "aclRights";
    private static final long serialVersionUID = -3203127456449579174L;
    private final Set<EntryRight> entryRights;
    private final Map<String, Set<AttributeRight>> attributeRights;

    public EffectiveRightsEntry(Entry entry) {
        super(entry);
        HashSet<String> options = new HashSet<String>(1);
        options.add("entryLevel");
        List<Attribute> attrList = this.getAttributesWithOptions(ATTR_ACL_RIGHTS, options);
        if (attrList == null || attrList.isEmpty()) {
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "No entry-level aclRights information contained in entry " + entry.getDN());
            }
            this.entryRights = null;
        } else {
            this.entryRights = Collections.unmodifiableSet(EffectiveRightsEntry.parseEntryRights(attrList));
        }
        options.clear();
        options.add("attributeLevel");
        attrList = this.getAttributesWithOptions(ATTR_ACL_RIGHTS, options);
        if (attrList == null || attrList.isEmpty()) {
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "No attribute-level aclRights information contained in entry " + entry.getDN());
            }
            this.attributeRights = null;
        } else {
            HashMap<String, Set<AttributeRight>> attrRightsMap = new HashMap<String, Set<AttributeRight>>(attrList.size());
            for (Attribute a : attrList) {
                Set<String> attrOptions = a.getOptions();
                String attrName = null;
                for (String s : attrOptions) {
                    if (s.equalsIgnoreCase("attributeLevel")) continue;
                    attrName = s;
                }
                if (attrName == null) {
                    if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                    Debug.debug(Level.WARNING, DebugType.LDAP, "Unable to determine the target attribute name from " + a.getName());
                    continue;
                }
                String lowerName = StaticUtils.toLowerCase(attrName);
                Set<AttributeRight> rights = EffectiveRightsEntry.parseAttributeRights(a);
                attrRightsMap.put(lowerName, rights);
            }
            this.attributeRights = Collections.unmodifiableMap(attrRightsMap);
        }
    }

    private static Set<EntryRight> parseEntryRights(List<Attribute> attrList) {
        EnumSet<EntryRight> entryRightsSet = EnumSet.noneOf(EntryRight.class);
        for (Attribute a : attrList) {
            for (String value : a.getValues()) {
                StringTokenizer tokenizer = new StringTokenizer(value, ", ");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!token.endsWith(":1")) continue;
                    String rightName = token.substring(0, token.length() - 2);
                    EntryRight r = EntryRight.forName(rightName);
                    if (r == null) {
                        if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                        Debug.debug(Level.WARNING, DebugType.LDAP, "Unrecognized entry right " + rightName);
                        continue;
                    }
                    entryRightsSet.add(r);
                }
            }
        }
        return entryRightsSet;
    }

    private static Set<AttributeRight> parseAttributeRights(Attribute a) {
        EnumSet<AttributeRight> rightsSet = EnumSet.noneOf(AttributeRight.class);
        for (String value : a.getValues()) {
            StringTokenizer tokenizer = new StringTokenizer(value, ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.endsWith(":1")) continue;
                String rightName = token.substring(0, token.length() - 2);
                AttributeRight r = AttributeRight.forName(rightName);
                if (r == null) {
                    if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                    Debug.debug(Level.WARNING, DebugType.LDAP, "Unrecognized attribute right " + rightName);
                    continue;
                }
                rightsSet.add(r);
            }
        }
        return rightsSet;
    }

    public boolean rightsInformationAvailable() {
        return this.entryRights != null || this.attributeRights != null;
    }

    public Set<EntryRight> getEntryRights() {
        return this.entryRights;
    }

    public boolean hasEntryRight(EntryRight entryRight) {
        Validator.ensureNotNull((Object)entryRight);
        return this.entryRights != null && this.entryRights.contains((Object)entryRight);
    }

    public Map<String, Set<AttributeRight>> getAttributeRights() {
        return this.attributeRights;
    }

    public Set<AttributeRight> getAttributeRights(String attributeName) {
        Validator.ensureNotNull(attributeName);
        if (this.attributeRights == null) {
            return null;
        }
        return this.attributeRights.get(StaticUtils.toLowerCase(attributeName));
    }

    public boolean hasAttributeRight(AttributeRight attributeRight, String attributeName) {
        Validator.ensureNotNull(attributeName, (Object)attributeRight);
        Set<AttributeRight> attrRights = this.getAttributeRights(attributeName);
        return attrRights != null && attrRights.contains((Object)attributeRight);
    }
}

