/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.uriinfo;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

@Path(value="resource")
public class URIInfoTest {
    public static final String ENCODED = "%50%51%52%30%39%70%71%72/%7e%2d%2E%5f";
    public static final String DECODED = "PQR09pqr/~-._";

    @GET
    @Path(value="/query")
    public String queryTest(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getQueryParameters().keySet()) {
            buf.append(param + "=" + (String)info.getQueryParameters().getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/query1")
    public String queryTest1(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getQueryParameters(true).keySet()) {
            buf.append(param + "=" + (String)info.getQueryParameters(true).getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/query2")
    public String queryTest2(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getQueryParameters(false).keySet()) {
            buf.append(param + "=" + (String)info.getQueryParameters(false).getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/apath")
    public String apathTest(@Context UriInfo info) {
        StringBuilder sb = new StringBuilder();
        URI uri = info.getAbsolutePath();
        UriBuilder urib = info.getAbsolutePathBuilder();
        sb.append(uri.toString());
        if (!uri.toString().equals(urib.build(new Object[0]).toString())) {
            sb.append("Got unexpected = " + urib.build(new Object[0]).toString());
            sb.append("FAILED");
        }
        return sb.toString();
    }

    @GET
    @Path(value="/path")
    public String pathTest(@Context UriInfo info) {
        return info.getPath();
    }

    @GET
    @Path(value="/path1%20/%2010")
    public String pathTest1(@Context UriInfo info) {
        return info.getPath(true);
    }

    @GET
    @Path(value="/path2%20/%2010")
    public String pathTest2(@Context UriInfo info) {
        return info.getPath(false);
    }

    @GET
    @Path(value="/baseuri")
    public String baseUriTest(@Context UriInfo info) {
        StringBuilder sb = new StringBuilder();
        URI uri = info.getBaseUri();
        UriBuilder urib = info.getBaseUriBuilder();
        sb.append(uri.toString());
        if (!uri.toString().equals(urib.build(new Object[0]).toString())) {
            sb.append("Got unexpected = " + urib.build(new Object[0]).toString());
            sb.append("FAILED");
        }
        return sb.toString();
    }

    @GET
    @Path(value="/pathparam/{a}/{b}")
    public String pathparamTest(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getPathParameters().keySet()) {
            buf.append(param + "=" + (String)info.getPathParameters().getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/pathparam1/{a}/{b}")
    public String pathparamTest1(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getPathParameters(true).keySet()) {
            buf.append(param + "=" + (String)info.getPathParameters(true).getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/pathparam2/{a}/{b}")
    public String pathparamTest2(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String param : info.getPathParameters(false).keySet()) {
            buf.append(param + "=" + (String)info.getPathParameters(false).getFirst((Object)param));
        }
        return buf.toString();
    }

    @GET
    @Path(value="/pathseg")
    public String pathsegTest(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (PathSegment param : info.getPathSegments()) {
            buf.append(param.getPath() + "/");
        }
        return buf.toString();
    }

    @GET
    @Path(value="/pathseg1%20/%2010")
    public String pathsegTest1(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (PathSegment param : info.getPathSegments(true)) {
            buf.append(param.getPath() + "/");
        }
        return buf.toString();
    }

    @GET
    @Path(value="/pathseg2%20/%2010")
    public String pathsegTest2(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (PathSegment param : info.getPathSegments(false)) {
            buf.append(param.getPath() + "/");
        }
        return buf.toString();
    }

    @GET
    @Path(value="/request")
    public String requestTest(@Context UriInfo info) {
        StringBuilder sb = new StringBuilder();
        URI uri = info.getRequestUri();
        UriBuilder urib = info.getRequestUriBuilder();
        sb.append(uri.toString());
        if (!uri.toString().equals(urib.build(new Object[0]).toString())) {
            sb.append("Got unexpected = " + urib.build(new Object[0]).toString());
            sb.append("FAILED");
        }
        return sb.toString();
    }

    @GET
    @Path(value="/resource")
    public String resourcesTest(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (Object resource : info.getMatchedResources()) {
            buf.append(resource.toString() + "=");
        }
        buf.append("number=" + info.getMatchedResources().size());
        return buf.toString();
    }

    @GET
    @Path(value="/uri")
    public String urisTest(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (Object resource : info.getMatchedURIs()) {
            buf.append(resource.toString() + "=");
        }
        buf.append("number=" + info.getMatchedURIs().size());
        return buf.toString();
    }

    @GET
    @Path(value="/uri1")
    public String urisTest1(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String resource : info.getMatchedURIs(true)) {
            buf.append(resource + "=");
        }
        buf.append("number=" + info.getMatchedURIs(true).size());
        return buf.toString();
    }

    @GET
    @Path(value="/uri2")
    public String urisTest2(@Context UriInfo info) {
        StringBuilder buf = new StringBuilder();
        for (String resource : info.getMatchedURIs(false)) {
            buf.append(resource + "=");
        }
        buf.append("number=" + info.getMatchedURIs(false).size());
        return buf.toString();
    }

    @GET
    @Path(value="{id1}/{id2}")
    public String normalizedUri(@Context UriInfo info) {
        int ret = 1;
        if (!info.getAbsolutePath().toString().contains(ENCODED)) {
            ret += 10;
        }
        if (!info.getPath().toString().contains(ENCODED)) {
            ret += 100;
        }
        if (!info.getRequestUri().toString().contains(ENCODED)) {
            ret += 1000;
        }
        return String.valueOf(ret);
    }
}

